<?php

/**
 * @file
 * Contains Modal Popup Callback for credit vendors
 */

/**
 * Callback function for adding a credit vendor
 * @param type $js
 * @return type
 */
function fernweh_vendor_add_modal_callback($js = FALSE) {
  if ($js) {
    // Include your ctools crap here
    ctools_include('taxonomy.admin', 'taxonomy', '');
    ctools_include('modal');
    ctools_include('ajax');

    // Create a blank term object here. You can also set values for your custom fields here as well.
    $vocabulary = taxonomy_vocabulary_load(2); // 3 is vocabulary id for credit vendor taxonomy

    $form_state = array(
      'title' => t('Add New Vendor'),
      'ajax' => TRUE,
    );

    $vocabulary->name = '';
    $vocabulary->description = '';
    $form_state['build_info']['args'] = array($vocabulary);

    $output = ctools_modal_form_wrapper('taxonomy_form_term', $form_state);

    if (!empty($form_state['executed'])) {
      $output = array();
      $output[] = ctools_modal_command_dismiss();
      $output[] = ctools_ajax_command_redirect('vendors', 1000);
    }

    print ajax_render($output);
    drupal_exit();
  }
  else {
    module_load_include('inc', 'taxonomy', 'taxonomy.admin');
    $vocabulary = taxonomy_vocabulary_load(2);
    $vocabulary->name = '';
    $vocabulary->description = '';
    return drupal_get_form('taxonomy_form_term', $vocabulary);
  }
}

/**
 * Callback function to edit vendor
 * @param type $js
 * @param type $termId
 * @return type
 */
function fernweh_vendor_edit_modal_callback($js = FALSE, $termId) {
  if ($js) {
    ctools_include('taxonomy.admin', 'taxonomy', '');
    ctools_include('modal');
    ctools_include('ajax');

    $term = taxonomy_term_load($termId);

    $form_state = array(
      'title' => t('Edit Vendor Details'),
      'ajax' => TRUE,
    );

    $form_state['build_info']['args'] = array($term);

    $output = ctools_modal_form_wrapper('taxonomy_form_term', $form_state);

    if (!empty($form_state['executed'])) {
      $output = array();
      $output[] = ctools_modal_command_dismiss();
      $output[] = ctools_ajax_command_redirect('vendors', 1000);
    }

    print ajax_render($output);
    drupal_exit();
  }
  else {
    module_load_include('inc', 'taxonomy', 'taxonomy.admin');
    $term = taxonomy_term_load($termId);
    return drupal_get_form('taxonomy_form_term', $term);
  }
}

/**
 * Callbak function to delete the vendor
 * @param type $js
 * @param type $termId
 * @return type
 */
function fernweh_vendor_delete_modal_callback($js = FALSE, $termId) {
  if ($js) {
    ctools_include('ajax');
    ctools_include('modal');
    ctools_add_js('ajax-responder');

    $form_state = array(
      'ajax' => TRUE,
      'title' => t('Delete Vendor'),
    );

    $output = ctools_modal_form_wrapper('vendor_delete_form', $form_state);

    if (!empty($form_state['ajax_commands'])) {
      $output = $form_state['ajax_commands'];
    }

    print ajax_render($output);
    drupal_exit();
  }
  else {
    return drupal_get_form('vendor_delete_form');
  }
}

/**
 * Delete vendor form
 * @param type $form
 * @param type $form_state
 * @return string
 */
function vendor_delete_form($form, $form_state) {
  $form = array();
  $form['delete_message']['#markup'] = '<h2>Are you sure you want to Delete?</h2>';
  $form['id'] = array(
    '#type' => 'hidden',
    '#value' => arg(3),
  );

  $form['actions']['cancel'] = array(
    '#markup' => l(t('Cancel'), '#', array(
      'attributes' => array(
        'class' => 'ctools-close-modal modal-cancel-btn'
      ),
      'external' => TRUE
        )
    )
  );
  $form['submit'] = array(
    '#type' => 'submit',
    '#value' => t('Delete'),
  );
  return $form;
}

/**
 * Delete vendor submit function
 * @param type $form
 * @param type $form_state
 */
function vendor_delete_form_submit(&$form, &$form_state) {
  $term = taxonomy_term_load($form_state['values']['id']);
  if (is_object($term)) {
    $term->status = 0;
    taxonomy_term_save($term);
    $form_state['ajax_commands'][] = ctools_modal_command_dismiss();
    drupal_set_message(t('Vendor information deleted successfully.'));
  }
  else {
    drupal_set_message(t('Some error occurred while deleting vendor.', 'error'));
  }
  $form_state['ajax_commands'][] = ctools_ajax_command_redirect('vendors', 100);
}

/**
 * Callback function to view the vendor details
 * @param type $js
 * @param type $termId
 * @return type
 */
function fernweh_vendor_view_modal_callback($js = FALSE, $termId) {
  if ($js) {
    ctools_include('ajax');
    ctools_include('modal');

    $form_state = array(
      'ajax' => TRUE,
      'title' => t('Vendor Details'),
    );

    $output = ctools_modal_form_wrapper('vendor_view_form', $form_state);

    if (!empty($form_state['ajax_commands'])) {
      $output = $form_state['ajax_commands'];
    }

    print ajax_render($output);
    drupal_exit();
  }
  else {
    return drupal_get_form('vendor_delete_form');
  }
}

/**
 * Form to display vendor basic details
 * @param type $form
 * @param type $form_state
 * @return type
 */
function vendor_view_form($form, $form_state) {
  $vendor = taxonomy_term_load(arg(3));
  $vendorHtml = '';
  $vendorHtml .= '<ul>';
//  if (is_object($vendor)) {
//    $vendorHtml .= ' <li><span>Card Number: </span>' . $vendor->field_vendor_number[LANGUAGE_NONE][0]['value'] . '</li>';
//    $vendorHtml .= ' <li><span>Bank Name: </span>' . $vendor->name . '</li>';
//    $vendorHtml .= ' <li><span>Type: </span>' . $vendor->field_vendor_type[LANGUAGE_NONE][0]['value'] . '</li>';
//    $vendorHtml .= ' <li><span>Available Credit: </span>' . $vendor->field_vendor_available_credit[LANGUAGE_NONE][0]['value'] . '</li>';
//    $vendorHtml .= ' <li><span>Credit Limit: </span>' . $vendor->field_vendor_credit_limit[LANGUAGE_NONE][0]['value'] . '</li>';
//  }
//  else {
//    $vendorHtml .= '<li>' . t('No information is available for this vendor.') . '</li>';
//  }

  $vendorHtml .= '<li>' . t('No information is available for this vendor.') . '</li>';

  $vendorHtml .= '</ul>';

  $form = array();
  $form['name'] = array(
    '#markup' => $vendorHtml,
  );
  $form['actions']['close'] = array(
    '#markup' => l(t('Close'), '#', array(
      'attributes' => array(
        'class' => 'ctools-close-modal modal-cancel-btn'
      ),
      'external' => TRUE
        )
    )
  );
  return $form;
}
