<?php
/**
 * @file
 * Template to display a view as a table.
 *
 * - $title : The title of this group of rows.  May be empty.
 * - $header: An array of header labels keyed by field id.
 * - $caption: The caption for this table. May be empty.
 * - $header_classes: An array of header classes keyed by field id.
 * - $fields: An array of CSS IDs to use for each field id.
 * - $classes: A class or classes to apply to the table, based on settings.
 * - $row_classes: An array of classes to apply to each row, indexed by row
 *   number. This matches the index in $rows.
 * - $rows: An array of row items. Each row is an array of content.
 *   $rows are keyed by row number, fields within rows are keyed by field ID.
 * - $field_classes: An array of classes to apply to each field, indexed by
 *   field id, then row number. This matches the index in $rows.
 * @ingroup views_templates
 */
?>
<table <?php
if ($classes) {
 // drupal_set_message($classses);
  print 'class="' . $classes . '" ';
}
?><?php print $attributes; ?>>
    <?php if (!empty($title) || !empty($caption)) : ?>
    <caption><?php print $caption . $title; ?></caption>
  <?php endif; ?>
  <?php if (!empty($header)) : ?>
    <thead>
      <tr>
        <?php foreach ($header as $field => $label): ?>
          <th <?php
          if ($header_classes[$field]) {
            print 'class="' . $header_classes[$field] . '" ';
          }
          ?>>
              <?php
              // CODE TO DETERMINE SORT LINKS AND CLASS
              $sortParam = filter_input(INPUT_GET, 'sort');
              $orderParam = filter_input(INPUT_GET, 'order');
              $sort = (isset($sortParam) && ($sortParam == "asc")) ? 'desc' : 'asc';
              $order = $field;
              $sortClass = (isset($sortParam)) ? array('fn-sort-' . $sortParam) : array('fn-sort-none');
              if ($field == "nothing") {
                print $label;
              }
              else {
                print l($label, 'orders', array('query' => array('sort' => $sort, 'order' => $order), 'attributes' => array('class' => $sortClass)));
              }
              ?>
          </th>
        <?php endforeach; ?>
        <th class="filter-header"><div class="filter-icon"><a title="<?php echo t('Click here to filter'); ?>" href="#">Filter</a></div></th>
  </tr>
  </thead>
<?php endif; ?>
<tbody>
  <tr id="filter-result" class="filter-result" style="display: none;">
    <td colspan="10">
      <a href="#" class="close filter-header"></a>
      <div class="calendar-range-wrapper">
        <form class="form-horizontal">
          <fieldset>
            <div class="control-group">
              <div class="controls">
                <div class="input-prepend input-group">
                  <span class="add-on input-group-addon"><i class="glyphicon glyphicon-calendar fa fa-calendar"></i></span><input type="text" style="width: 200px" name="closing-date" id="closing-date" class="form-control" value="03/18/2013 - 03/23/2013" /> 
                </div>
              </div>
            </div>
          </fieldset>
        </form>
          <script type="text/javascript">
              jQuery(document).ready(function() {

                  var date = new Date();
                  var day = ("0"+date.getDate()).slice(-2);
                  var monthIndex = ("0"+(date.getMonth()+1)).slice(-2);
                  var year = date.getFullYear();
                  var monthEnd = new Date(year, monthIndex, 0).getDate();
                  var startDate = year+'-'+monthIndex+'-'+day;
                  var endDate = year+'-'+monthIndex+'-'+monthEnd;

                  jQuery('#closing-date').val(startDate +' - '+ startDate);

                  jQuery('#closing-date').daterangepicker({
                      opens: 'left',
                      format: 'YYYY-MM-DD',
                      startDate: startDate,
                      endDate: startDate
                  }, function(start, end, label) {
                      //console.log(start.toISOString(), end.toISOString(), label);
                  });
              });
          </script>
      </div>
      <div class="edit-type"><label>Filter </label>
          <select id="order-status-select" name="status" class="filter">
              <option value="All">Status (All)</option>
          </select>
      </div>
    </td>
  </tr>
  <?php foreach ($rows as $row_count => $row): ?>
    <tr <?php
    if ($row_classes[$row_count]) {
      print 'class="' . implode(' ', $row_classes[$row_count]) . '"';
    }
    ?>>
        <?php foreach ($row as $field => $content): ?>
        <td <?php
        if ($field_classes[$field][$row_count]) {
          print 'class="' . $field_classes[$field][$row_count] . '" ';
        }
        ?><?php //print drupal_attributes($field_attributes[$field][$row_count]);   ?> <?php echo ($field == "edit_product") ? ' colspan="2"' : ''; ?>>
            <?php print $content; ?>
        </td>
      <?php endforeach; ?>
    </tr>
  <?php endforeach; ?>
</tbody>
</table>
