<?php
/**
 * @file
 * Bulk export of heartbeat objects generated by Bulk export module.
 */

/**
 * Implements hook_heartbeat_stream_info().
 */
function heartbeat_og_heartbeat_stream_info() {

  $heartbeatstreams = array();

  /**
   * groupactivity
   */
  $heartbeatstream = new HeartbeatStreamConfig;
  $heartbeatstream->disabled = FALSE; /* Edit this to true to make a default heartbeatstream disabled initially */
  $heartbeatstream->api_version = 1;
  $heartbeatstream->class = 'groupactivity';
  $heartbeatstream->name = 'Group activity';
  $heartbeatstream->module = 'heartbeat_plugins';
  $heartbeatstream->title = 'Group activity';
  $heartbeatstream->path = 'streams/groupactivity.inc';
  $heartbeatstream->settings = array(
    'settings__active_tab' => 'edit-settings-fs-blocks',
    'messages_denied' => array(
    ),
    'skip_active_user' => 0,
    'show_message_times' => 1,
    'show_message_times_grouped' => 1,
    'poll_messages' => '0',
    'num_load_max' => '100',
    'grouping_seconds' => '7200',
    'has_block' => 1,
    'block_items_max' => '5',
    'block_show_pager' => '1',
    'block_view_mode' => 'default',
    'stream_path' => '',
    'stream_profile_path' => '',
    'page_items_max' => '8',
    'page_show_pager' => 0,
    'page_pager_ajax' => 0,
    'page_view_mode' => 'default',
    'show_status_form' => '0',
    'shoutbox' => 0,
  );
  $heartbeatstream->variables = array();
  $heartbeatstreams['groupactivity'] = $heartbeatstream;

  /**
   * groupsactivity
   */
  $heartbeatstream = new HeartbeatStreamConfig;
  $heartbeatstream->disabled = FALSE; /* Edit this to true to make a default heartbeatstream disabled initially */
  $heartbeatstream->api_version = 1;
  $heartbeatstream->class = 'groupsactivity';
  $heartbeatstream->name = 'Groups activity';
  $heartbeatstream->module = 'heartbeat_plugins';
  $heartbeatstream->title = 'Activity from all groups';
  $heartbeatstream->path = 'streams/groupsactivity.inc';
  $heartbeatstream->settings = array(
    'settings__active_tab' => 'edit-settings-fs-blocks',
    'messages_denied' => array(
    ),
    'skip_active_user' => 0,
    'show_message_times' => 1,
    'show_message_times_grouped' => 1,
    'poll_messages' => '0',
    'num_load_max' => '100',
    'grouping_seconds' => '7200',
    'has_block' => 1,
    'block_items_max' => '5',
    'block_show_pager' => '1',
    'block_view_mode' => 'default',
    'stream_path' => 'groups-activity',
    'stream_profile_path' => 'groups-activity',
    'page_items_max' => '8',
    'page_show_pager' => 0,
    'page_pager_ajax' => 0,
    'page_view_mode' => 'default',
    'show_status_form' => '0',
    'shoutbox' => 0,
  );
  $heartbeatstream->variables = array();
  $heartbeatstreams['groupsactivity'] = $heartbeatstream;

  /**
   * membersactivity
   */
  $heartbeatstream = new HeartbeatStreamConfig;
  $heartbeatstream->disabled = FALSE; /* Edit this to true to make a default heartbeatstream disabled initially */
  $heartbeatstream->api_version = 1;
  $heartbeatstream->class = 'membersactivity';
  $heartbeatstream->name = 'Members activity';
  $heartbeatstream->module = 'heartbeat_plugins';
  $heartbeatstream->title = 'Activity from all members in a group';
  $heartbeatstream->path = 'streams/membersactivity.inc';
  $heartbeatstream->settings = array(
    'settings__active_tab' => 'edit-settings-fs-blocks',
    'messages_denied' => array(
    ),
    'skip_active_user' => 0,
    'show_message_times' => 1,
    'show_message_times_grouped' => 1,
    'poll_messages' => '0',
    'num_load_max' => '100',
    'grouping_seconds' => '7200',
    'has_block' => 1,
    'block_items_max' => '5',
    'block_show_pager' => '1',
    'block_view_mode' => 'default',
    'stream_path' => '',
    'stream_profile_path' => '',
    'page_items_max' => '8',
    'page_show_pager' => 0,
    'page_pager_ajax' => 0,
    'page_view_mode' => 'default',
    'show_status_form' => '0',
    'shoutbox' => 0,
  );
  $heartbeatstream->variables = array();
  $heartbeatstreams['membersactivity'] = $heartbeatstream;

  return $heartbeatstreams;

}

/**
 * Implements hook_heartbeat_template_info().
 */
function heartbeat_og_heartbeat_template_info() {

  $heartbeatmessagetemplates = array();

  /**
   * heartbeat_add_grouppost
   */
  $heartbeatmessagetemplate = new HeartbeatMessageTemplate();
  $heartbeatmessagetemplate->disabled = FALSE; /* Edit this to true to make a default heartbeatmessagetemplate disabled initially */
  $heartbeatmessagetemplate->api_version = 1;
  $heartbeatmessagetemplate->message_id = 'heartbeat_add_grouppost';
  $heartbeatmessagetemplate->description = 'User adds a group-post, save user activity';
  $heartbeatmessagetemplate->message = '!username has added !node_type !node_title in !group.';
  $heartbeatmessagetemplate->message_concat = 'username has added %node_title% in !group.';
  $heartbeatmessagetemplate->perms = 4;
  $heartbeatmessagetemplate->group_type = 'summary';
  $heartbeatmessagetemplate->concat_args = array(
    'group_by' => 'node-target',
    'group_target' => 'node_title',
    'group_by_target' => 'group',
    'group_num_max' => '3',
    'merge_separator' => ', ',
    'merge_end_separator' => ' and ',
    'roles' => array(
      2 => '2',
      1 => 0,
      3 => 0,
      4 => 0,
      5 => 0,
    ),
  );
  $heartbeatmessagetemplate->attachments = array(
    'buttons' => array(
      'weight' => array(
        'activitycomments' => '-9',
        'flagattachment:like' => '0',
      ),
      'settings' => array(
        'activitycomments' => array(
          'activitycomments_node' => 1,
        ),
      ),
      'enabled' => array(
        'activitycomments' => 'activitycomments',
        'flagattachment:like' => 0,
      ),
    ),
    'content' => array(
      'weight' => array(
        'activitycomments' => '-9',
        'flagattachment:like' => '0',
      ),
      'enabled' => array(
        'activitycomments' => 'activitycomments',
        'flagattachment:like' => 0,
      ),
    ),
  );
  $heartbeatmessagetemplates['heartbeat_add_grouppost'] = $heartbeatmessagetemplate;

  /**
   * heartbeat_become_group_member
   */
  $heartbeatmessagetemplate = new HeartbeatMessageTemplate();
  $heartbeatmessagetemplate->disabled = FALSE; /* Edit this to true to make a default heartbeatmessagetemplate disabled initially */
  $heartbeatmessagetemplate->api_version = 1;
  $heartbeatmessagetemplate->message_id = 'heartbeat_become_group_member';
  $heartbeatmessagetemplate->description = 'Activity of a user becoming member of a group';
  $heartbeatmessagetemplate->message = '!username became member of !group.';
  $heartbeatmessagetemplate->message_concat = '%username% just became member of !group.';
  $heartbeatmessagetemplate->perms = 4;
  $heartbeatmessagetemplate->group_type = 'summary';
  $heartbeatmessagetemplate->concat_args = array(
    'group_by' => 'node',
    'group_target' => 'username',
    'group_by_target' => 'group',
    'group_num_max' => '5',
    'merge_separator' => ', ',
    'merge_end_separator' => ' and ',
    'roles' => array(
      1 => 0,
      2 => 0,
      3 => 0,
      4 => 0,
      5 => 0,
    ),
  );
  $heartbeatmessagetemplate->variables = array(
    '!username' => '',
    '!group' => '',
  );
  $heartbeatmessagetemplate->attachments = array(
    'buttons' => array(
      'weight' => array(
        'activitycomments' => -9,
      ),
      'settings' => array(
        'activitycomments' => array(
          'activitycomments_node' => 1,
        ),
      ),
      'enabled' => array(
        'activitycomments' => 'activitycomments',
      ),
    ),
    'content' => array(
      'weight' => array(
        'activitycomments' => -9,
      ),
      'enabled' => array(
        'activitycomments' => 'activitycomments',
      ),
    ),
  );
  $heartbeatmessagetemplates['heartbeat_become_group_member'] = $heartbeatmessagetemplate;

  return $heartbeatmessagetemplates;

}