<?php
/**
 * The lead context.
 */
class statuses_lead_context extends statuses_context {

    function type() {
        return 'commerce_product';
        //commerce_product_load($product_id)
    }

    function recipient_id($recipient) {
        return isset($recipient->product_id) ? $recipient->product_id : 0;
    }

    function load_random_recipient() {
//    $nid = db_query_range("SELECT nid FROM {node} ORDER BY RAND() ASC", 0, 1)->fetchField();
//    return node_load($nid);
        return commerce_product_load(1);
    }

    function access_add($recipient, $sender) {
        return parent::access_add($recipient, $sender) || $sender->uid == $recipient->uid;
    }

    function access_delete($status, $account) {
        return parent::access_delete($status, $account) ||
        (user_access('delete status messages on own nodes', $account) && $this->load_recipient($status->recipient)->uid == $account->uid);
    }

    function access_view($status, $account) {
        return parent::access_view($status, $account) ||
        $this->load_recipient($status->recipient)->uid == $account->uid;
    }

    function access_stream($recipient, $account) {
        return parent::access_stream($recipient, $account) || $recipient->uid == $account->uid;
    }

}