<?php

/**
 * @file
 * Contains Modal Popup Callback for credit cards
 */

/**
 * Callback function for adding a credit card
 * @param type $js
 * @return type
 */
function fernweh_card_add_modal_callback($js = FALSE) {
  if ($js) {
    // Include your ctools crap here
    ctools_include('taxonomy.admin', 'taxonomy', '');
    ctools_include('modal');
    ctools_include('ajax');

    // Create a blank term object here. You can also set values for your custom fields here as well.
    $vocabulary = taxonomy_vocabulary_load(3); // 3 is vocabulary id for credit card taxonomy

    $form_state = array(
      'title' => t('Add New Credit Card'),
      'ajax' => TRUE,
    );

    $vocabulary->name = '';
    $vocabulary->description = '';
    $form_state['build_info']['args'] = array($vocabulary);

    $output = ctools_modal_form_wrapper('taxonomy_form_term', $form_state);

    if (!empty($form_state['executed'])) {
      $output = array();
      $output[] = ctools_modal_command_dismiss();
      $output[] = ctools_ajax_command_redirect('cards', 1000);
    }

    print ajax_render($output);
    drupal_exit();
  }
  else {
    module_load_include('inc', 'taxonomy', 'taxonomy.admin');
    $vocabulary = taxonomy_vocabulary_load(3);
    $vocabulary->name = '';
    $vocabulary->description = '';
    return drupal_get_form('taxonomy_form_term', $vocabulary);
  }
}

/**
 * Callback function to edit card
 * @param type $js
 * @param type $termId
 * @return type
 */
function fernweh_card_edit_modal_callback($js = FALSE, $termId) {
  if ($js) {
    ctools_include('taxonomy.admin', 'taxonomy', '');
    ctools_include('modal');
    ctools_include('ajax');

    $term = taxonomy_term_load($termId);

    $form_state = array(
      'title' => t('Edit Credit Card Details'),
      'ajax' => TRUE,
    );

    $form_state['build_info']['args'] = array($term);

    $output = ctools_modal_form_wrapper('taxonomy_form_term', $form_state);

    if (!empty($form_state['executed'])) {
      $output = array();
      $output[] = ctools_modal_command_dismiss();
      $output[] = ctools_ajax_command_redirect('cards', 1000);
    }

    print ajax_render($output);
    drupal_exit();
  }
  else {
    module_load_include('inc', 'taxonomy', 'taxonomy.admin');
    $term = taxonomy_term_load($termId);
    return drupal_get_form('taxonomy_form_term', $term);
  }
}

/**
 * Callbak function to delete the card
 * @param type $js
 * @param type $termId
 * @return type
 */
function fernweh_card_delete_modal_callback($js = FALSE, $termId) {
  if ($js) {
    ctools_include('ajax');
    ctools_include('modal');
    ctools_add_js('ajax-responder');

    $form_state = array(
      'ajax' => TRUE,
      'title' => t('Delete Card'),
    );

    $output = ctools_modal_form_wrapper('card_delete_form', $form_state);

    if (!empty($form_state['ajax_commands'])) {
      $output = $form_state['ajax_commands'];
    }

    print ajax_render($output);
    drupal_exit();
  }
  else {
    return drupal_get_form('card_delete_form');
  }
}

/**
 * Delete card form
 * @param type $form
 * @param type $form_state
 * @return string
 */
function card_delete_form($form, $form_state) {
  $form = array();
  $form['delete_message']['#markup'] = '<h2>Are you sure you want to Delete?</h2>';
  $form['id'] = array(
    '#type' => 'hidden',
    '#value' => arg(3),
  );

  $form['actions']['cancel'] = array(
    '#markup' => l(t('Cancel'), '#', array(
      'attributes' => array(
        'class' => 'ctools-close-modal modal-cancel-btn'
      ),
      'external' => TRUE
        )
    )
  );
  $form['submit'] = array(
    '#type' => 'submit',
    '#value' => t('Delete'),
  );
  return $form;
}

/**
 * Delete card submit function
 * @param type $form
 * @param type $form_state
 */
function card_delete_form_submit(&$form, &$form_state) {
  $term = taxonomy_term_load($form_state['values']['id']);
  if (is_object($term)) {
    $term->status = 0;
    taxonomy_term_save($term);
    $form_state['ajax_commands'][] = ctools_modal_command_dismiss();
    drupal_set_message(t('Card information deleted successfully.'));
  }
  else {
    drupal_set_message(t('Some error occurred while deleting card.', 'error'));
  }
  $form_state['ajax_commands'][] = ctools_ajax_command_redirect('cards');
}

/**
 * Callback function to view the card details
 * @param type $js
 * @param type $termId
 * @return type
 */
function fernweh_card_view_modal_callback($js = FALSE, $termId) {
  if ($js) {
    ctools_include('ajax');
    ctools_include('modal');

    $form_state = array(
      'ajax' => TRUE,
      'title' => t('Card Details'),
    );

    $output = ctools_modal_form_wrapper('card_view_form', $form_state);

    if (!empty($form_state['ajax_commands'])) {
      $output = $form_state['ajax_commands'];
    }

    print ajax_render($output);
    drupal_exit();
  }
  else {
    return drupal_get_form('card_delete_form');
  }
}

/**
 * Form to display card basic details
 * @param type $form
 * @param type $form_state
 * @return type
 */
function card_view_form($form, $form_state) {
  $card = taxonomy_term_load(arg(3));
  $cardHtml = '';
  $cardHtml .= '<ul>';
  if (is_object($card)) {
    $cardHtml .= ' <li><span>Card Number: </span>' . $card->field_card_number[LANGUAGE_NONE][0]['value'] . '</li>';
    $cardHtml .= ' <li><span>Bank Name: </span>' . $card->name . '</li>';
    $cardHtml .= ' <li><span>Type: </span>' . $card->field_card_type[LANGUAGE_NONE][0]['value'] . '</li>';
    $cardHtml .= ' <li><span>Available Credit: </span>' . $card->field_card_available_credit[LANGUAGE_NONE][0]['value'] . '</li>';
    //$cardHtml .= ' <li><span>Credit Limit: </span>' . $card->field_card_credit_limit[LANGUAGE_NONE][0]['value'] . '</li>';
  }
  else {
    $cardHtml .= '<li>' . t('No information is available for this card.') . '</li>';
  }

  $cardHtml .= '</ul>';

  $form = array();
  $form['name'] = array(
    '#markup' => $cardHtml,
  );
  $form['actions']['close'] = array(
    '#markup' => l(t('Close'), '#', array(
      'attributes' => array(
        'class' => 'ctools-close-modal modal-cancel-btn'
      ),
      'external' => TRUE
        )
    )
  );
  return $form;
}
