<?php

/**
 * @file
 * Contains Modal Popup Callback for credit sources
 */

/**
 * Callback function for adding a credit source
 * @param type $js
 * @return type
 */
function fernweh_source_add_modal_callback($js = FALSE) {
  if ($js) {
    ctools_include('taxonomy.admin', 'taxonomy', '');
    ctools_include('modal');
    ctools_include('ajax');

    // Create a blank term object here. You can also set values for your custom fields here as well.
    $vocabulary = taxonomy_vocabulary_load(4); // 4 is vocabulary id for credit source taxonomy

    $form_state = array(
      'title' => t('Add New Credit Card'),
      'ajax' => TRUE,
    );

    $vocabulary->name = '';
    $vocabulary->description = '';
    $form_state['build_info']['args'] = array($vocabulary);

    $output = ctools_modal_form_wrapper('taxonomy_form_term', $form_state);

    if (!empty($form_state['executed'])) {
      $output = array();
      $output[] = ctools_modal_command_dismiss();
      $output[] = ctools_ajax_command_redirect('sources', 1000);
    }

    print ajax_render($output);
    drupal_exit();
  }
  else {
    module_load_include('inc', 'taxonomy', 'taxonomy.admin');
    $vocabulary = taxonomy_vocabulary_load(4);
    $vocabulary->name = '';
    $vocabulary->description = '';
    return drupal_get_form('taxonomy_form_term', $vocabulary);
  }
}

/**
 * Callback function to edit source
 * @param type $js
 * @param type $termId
 * @return type
 */
function fernweh_source_edit_modal_callback($js = FALSE, $termId) {
  if ($js) {
    ctools_include('taxonomy.admin', 'taxonomy', '');
    ctools_include('modal');
    ctools_include('ajax');

    $term = taxonomy_term_load($termId);

    $form_state = array(
      'title' => t('Edit Source Details'),
      'ajax' => TRUE,
    );

    $form_state['build_info']['args'] = array($term);

    $output = ctools_modal_form_wrapper('taxonomy_form_term', $form_state);

    if (!empty($form_state['executed'])) {
      $output = array();
      $output[] = ctools_modal_command_dismiss();
      $output[] = ctools_ajax_command_redirect('sources', 1000);
    }

    print ajax_render($output);
    drupal_exit();
  }
  else {
    module_load_include('inc', 'taxonomy', 'taxonomy.admin');
    $term = taxonomy_term_load($termId);
    return drupal_get_form('taxonomy_form_term', $term);
  }
}

/**
 * Callbak function to delete the source
 * @param type $js
 * @param type $termId
 * @return type
 */
function fernweh_source_delete_modal_callback($js = FALSE, $termId) {
  if ($js) {
    ctools_include('ajax');
    ctools_include('modal');
    ctools_add_js('ajax-responder');

    $form_state = array(
      'ajax' => TRUE,
      'title' => t('Delete Source'),
    );

    $output = ctools_modal_form_wrapper('source_delete_form', $form_state);

    if (!empty($form_state['ajax_commands'])) {
      $output = $form_state['ajax_commands'];
    }

    print ajax_render($output);
    drupal_exit();
  }
  else {
    return drupal_get_form('source_delete_form');
  }
}

/**
 * Delete source form
 * @param type $form
 * @param type $form_state
 * @return string
 */
function source_delete_form($form, $form_state) {
  $form = array();
  $form['delete_message']['#markup'] = '<h2>Are you sure you want to Delete?</h2>';
  $form['id'] = array(
    '#type' => 'hidden',
    '#value' => arg(3),
  );

  $form['actions']['cancel'] = array(
    '#markup' => l(t('Cancel'), '#', array(
      'attributes' => array(
        'class' => 'ctools-close-modal modal-cancel-btn'
      ),
      'external' => TRUE
        )
    )
  );
  $form['submit'] = array(
    '#type' => 'submit',
    '#value' => t('Delete'),
  );
  return $form;
}

/**
 * Delete source submit function
 * @param type $form
 * @param type $form_state
 */
function source_delete_form_submit(&$form, &$form_state) {
  $term = taxonomy_term_load($form_state['values']['id']);
  if (is_object($term)) {
    $term->status = 0;
    taxonomy_term_save($term);
    $form_state['ajax_commands'][] = ctools_modal_command_dismiss();
    drupal_set_message(t('Card information deleted successfully.'));
  }
  else {
    drupal_set_message(t('Some error occurred while deleting source.', 'error'));
  }
  $form_state['ajax_commands'][] = ctools_ajax_command_redirect('sources');
}

/**
 * Callback function to view the source details
 * @param type $js
 * @param type $termId
 * @return type
 */
function fernweh_source_view_modal_callback($js = FALSE, $termId) {
  if ($js) {
    ctools_include('ajax');
    ctools_include('modal');

    $form_state = array(
      'ajax' => TRUE,
      'title' => t('Source Details'),
    );

    $output = ctools_modal_form_wrapper('source_view_form', $form_state);

    if (!empty($form_state['ajax_commands'])) {
      $output = $form_state['ajax_commands'];
    }

    print ajax_render($output);
    drupal_exit();
  }
  else {
    return drupal_get_form('source_delete_form');
  }
}

/**
 * Form to display source basic details
 * @param type $form
 * @param type $form_state
 * @return type
 */
function source_view_form($form, $form_state) {
  $source = taxonomy_term_load(arg(3));
  $sourceHtml = '';
  $sourceHtml .= '<ul>';
//  if (is_object($source)) {
//    $sourceHtml .= ' <li><span>Card Number: </span>' . $source->field_source_number[LANGUAGE_NONE][0]['value'] . '</li>';
//    $sourceHtml .= ' <li><span>Bank Name: </span>' . $source->name . '</li>';
//    $sourceHtml .= ' <li><span>Type: </span>' . $source->field_source_type[LANGUAGE_NONE][0]['value'] . '</li>';
//    $sourceHtml .= ' <li><span>Available Credit: </span>' . $source->field_source_available_credit[LANGUAGE_NONE][0]['value'] . '</li>';
//    $sourceHtml .= ' <li><span>Credit Limit: </span>' . $source->field_source_credit_limit[LANGUAGE_NONE][0]['value'] . '</li>';
//  }
//  else {
//    $sourceHtml .= '<li>' . t('No information is available for this source.') . '</li>';
//  }

  $sourceHtml .= '<li>' . t('No information is available for this source.') . '</li>';

  $sourceHtml .= '</ul>';

  $form = array();
  $form['name'] = array(
    '#markup' => $sourceHtml,
  );
  $form['actions']['close'] = array(
    '#markup' => l(t('Close'), '#', array(
      'attributes' => array(
        'class' => 'ctools-close-modal modal-cancel-btn'
      ),
      'external' => TRUE
        )
    )
  );
  return $form;
}
