<?php

function fernweh_user_delete_modal_callback($js = FALSE, $termId) {
  if ($js) {
    ctools_include('ajax');
    ctools_include('modal');
    ctools_add_js('ajax-responder');

    $form_state = array(
      'ajax' => TRUE,
      'title' => t('Delete User'),
    );

    $output = ctools_modal_form_wrapper('user_delete_form', $form_state);

    if (!empty($form_state['ajax_commands'])) {
      $output = $form_state['ajax_commands'];
    }

    print ajax_render($output);
    drupal_exit();
  }
  else {
    return drupal_get_form('user_delete_form');
  }
}

function user_delete_form($form, $form_state) {
  $form = array();
  $form['delete_message']['#markup'] = '<h2>Are you sure you want to Delete?</h2>';
  $form['id'] = array(
    '#type' => 'hidden',
    '#value' => arg(3),
  );

  $form['actions']['cancel'] = array(
    '#markup' => l(t('Cancel'), '#', array(
      'attributes' => array(
        'class' => 'ctools-close-modal modal-cancel-btn'
      ),
      'external' => TRUE
        )
    )
  );
  $form['submit'] = array(
    '#type' => 'submit',
    '#value' => t('Delete'),
  );
  return $form;
}

/**
 * Delete user submit function
 * @param type $form
 * @param type $form_state
 */
function user_delete_form_submit(&$form, &$form_state) {
  $user = user_load($form_state['values']['id']);
  if (is_object($user)) {

    user_delete($user->uid);

    $form_state['ajax_commands'][] = ctools_modal_command_dismiss();
    drupal_set_message(t('User information deleted successfully.'));
  }
  else {
    drupal_set_message(t('Some error occurred while deleting user.', 'error'));
  }
  $form_state['ajax_commands'][] = ctools_ajax_command_redirect('users', 100);
}
