<?php
/**
 * @file
 * Omega theme implementation to present all user profile data.
 *
 * This template is used when viewing a registered member's profile page,
 * e.g., example.com/user/123. 123 being the users ID.
 *
 * Use render($user_profile) to print all profile items, or print a subset
 * such as render($user_profile['user_picture']). Always call
 * render($user_profile) at the end in order to print all remaining items. If
 * the item is a category, it will contain all its profile items. By default,
 * $user_profile['member_for'] is provided, which contains data on the user's
 * history. Other data can be included by modules. $user_profile['user_picture']
 * is available for showing the account picture.
 *
 * Available variables:
 *   - $user_profile: An array of profile items. Use render() to print them.
 *   - Field variables: for each field instance attached to the user a
 *     corresponding variable is defined; e.g., $account->field_example has a
 *     variable $field_example defined. When needing to access a field's raw
 *     values, developers/themers are strongly encouraged to use these
 *     variables. Otherwise they will have to explicitly specify the desired
 *     field language, e.g. $account->field_example['en'], thus overriding any
 *     language negotiation rule that was previously applied.
 *
 * @see template_preprocess_user_profile()
 */
?>
<article<?php print $attributes; ?>>
  <?php print render($user_profile); ?>
  <div class="view-header">
    <?php
    global $user, $base_url;
    $account = $elements['#account'];
    ?>
    <h1>User Details</h1><a href="<?php print $base_url; ?>/user/<?php print $account->uid; ?>/edit" class="fn-edit-green">Edit Profile</a>
  </div>
  <div class="view-content">
    <div id = 'user-details-wrapper' class="detail-box-wrapper" >
      <div class = 'box-heading-left'>
        <span><?php
          $profile_pic = $user_profile['user_picture']['#markup'];
          echo $profile_pic;
          ?></span>
      </div>
      <div class = 'box-content-wrapper-rigth'>
        <div class="inner-content-wrapper">
          <div class = 'field_wrapper'>
            <div class = 'field_name'>Username</div>
            <div class= 'field_value'><?php echo $account->name; ?></div>
          </div>
          <div class = 'field_wrapper'>
            <div class = 'field_name'>Email</div>
            <div class = 'field_value'><?php print $account->mail; ?></div>
          </div>
          <div class = 'field_wrapper'>
            <div class = 'field_name'>First Name</div>
            <div class= 'field_value'><?php echo $user_profile['field_user_first_name']['#items'][0]['value']; ?></div>
          </div>
          <div class = 'field_wrapper'>
            <div class = 'field_name'>Last Name</div>
            <div class= 'field_value'><?php echo $user_profile['field_user_last_name']['#items'][0]['value']; ?></div>
          </div>
        </div>
      </div>
    </div>
  </div>
</article>
