<?php

/**
 * @file
 * Defines the default currency list of active currencies from ISO 4217.
 */


/**
 * Implements hook_commerce_currency_info().
 */
function commerce_commerce_currency_info() {
  return array(
    'AED' => array(
      'code' => 'AED',
      'symbol' => 'د.إ',
      'name' => t('United Arab Emirates Dirham'),
      'numeric_code' => '784',
      'code_placement' => 'before',
      'minor_unit' => t('Fils'),
      'major_unit' => t('Dirham'),
    ),
    'AFN' => array(
      'code' => 'AFN',
      'symbol' => 'Af',
      'name' => t('Afghan Afghani'),
      'decimals' => 0,
      'numeric_code' => '971',
      'minor_unit' => t('Pul'),
      'major_unit' => t('Afghani'),
    ),
    'ANG' => array(
      'code' => 'ANG',
      'symbol' => 'NAf.',
      'name' => t('Netherlands Antillean Guilder'),
      'numeric_code' => '532',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Guilder'),
    ),
    'AOA' => array(
      'code' => 'AOA',
      'symbol' => 'Kz',
      'name' => t('Angolan Kwanza'),
      'numeric_code' => '973',
      'minor_unit' => t('Cêntimo'),
      'major_unit' => t('Kwanza'),
    ),
    'ARM' => array(
      'code' => 'ARM',
      'symbol' => 'm$n',
      'name' => t('Argentine Peso Moneda Nacional'),
      'minor_unit' => t('Centavos'),
      'major_unit' => t('Peso'),
    ),
    'ARS' => array(
      'code' => 'ARS',
      'symbol' => 'AR$',
      'name' => t('Argentine Peso'),
      'numeric_code' => '032',
      'minor_unit' => t('Centavo'),
      'major_unit' => t('Peso'),
    ),
    'AUD' => array(
      'code' => 'AUD',
      'symbol' => '$',
      'name' => t('Australian Dollar'),
      'numeric_code' => '036',
      'symbol_placement' => 'before',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Dollar'),
    ),
    'AWG' => array(
      'code' => 'AWG',
      'symbol' => 'Afl.',
      'name' => t('Aruban Florin'),
      'numeric_code' => '533',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Guilder'),
    ),
    'AZN' => array(
      'code' => 'AZN',
      'symbol' => 'man.',
      'name' => t('Azerbaijanian Manat'),
      'minor_unit' => t('Qəpik'),
      'major_unit' => t('New Manat'),
    ),
    'BAM' => array(
      'code' => 'BAM',
      'symbol' => 'KM',
      'name' => t('Bosnia-Herzegovina Convertible Mark'),
      'numeric_code' => '977',
      'minor_unit' => t('Fening'),
      'major_unit' => t('Convertible Marka'),
    ),
    'BBD' => array(
      'code' => 'BBD',
      'symbol' => 'Bds$',
      'name' => t('Barbadian Dollar'),
      'numeric_code' => '052',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Dollar'),
    ),
    'BDT' => array(
      'code' => 'BDT',
      'symbol' => 'Tk',
      'name' => t('Bangladeshi Taka'),
      'numeric_code' => '050',
      'minor_unit' => t('Paisa'),
      'major_unit' => t('Taka'),
    ),
   'BGN' => array(
     'code' => 'BGN',
     'symbol' => 'лв',
     'name' => t('Bulgarian lev'),
     'thousands_separator' => ' ',
     'decimal_separator' => ',',
     'symbol_placement' => 'after',
     'code_placement' => 'hidden',
     'numeric_code' => '975',
     'minor_unit' => t('Stotinka'),
     'major_unit' => t('Lev'),
    ),
    'BHD' => array(
      'code' => 'BHD',
      'symbol' => 'BD',
      'name' => t('Bahraini Dinar'),
      'decimals' => 3,
      'numeric_code' => '048',
      'minor_unit' => t('Fils'),
      'major_unit' => t('Dinar'),
    ),
    'BIF' => array(
      'code' => 'BIF',
      'symbol' => 'FBu',
      'name' => t('Burundian Franc'),
      'decimals' => 0,
      'numeric_code' => '108',
      'minor_unit' => t('Centime'),
      'major_unit' => t('Franc'),
    ),
    'BMD' => array(
      'code' => 'BMD',
      'symbol' => 'BD$',
      'name' => t('Bermudan Dollar'),
      'numeric_code' => '060',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Dollar'),
    ),
    'BND' => array(
      'code' => 'BND',
      'symbol' => 'BN$',
      'name' => t('Brunei Dollar'),
      'numeric_code' => '096',
      'minor_unit' => t('Sen'),
      'major_unit' => t('Dollar'),
    ),
    'BOB' => array(
      'code' => 'BOB',
      'symbol' => 'Bs',
      'name' => t('Bolivian Boliviano'),
      'numeric_code' => '068',
      'minor_unit' => t('Centavo'),
      'major_unit' => t('Bolivianos'),
    ),
    'BRL' => array(
      'code' => 'BRL',
      'symbol' => 'R$',
      'name' => t('Brazilian Real'),
      'numeric_code' => '986',
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'thousands_separator' => '.',
      'decimal_separator' => ',',
      'minor_unit' => t('Centavo'),
      'major_unit' => t('Reais'),
    ),
    'BSD' => array(
      'code' => 'BSD',
      'symbol' => 'BS$',
      'name' => t('Bahamian Dollar'),
      'numeric_code' => '044',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Dollar'),
    ),
    'BTN' => array(
      'code' => 'BTN',
      'symbol' => 'Nu.',
      'name' => t('Bhutanese Ngultrum'),
      'numeric_code' => '064',
      'minor_unit' => t('Chetrum'),
      'major_unit' => t('Ngultrum'),
    ),
    'BWP' => array(
      'code' => 'BWP',
      'symbol' => 'BWP',
      'name' => t('Botswanan Pula'),
      'numeric_code' => '072',
      'minor_unit' => t('Thebe'),
      'major_unit' => t('Pulas'),
    ),
    'BYR' => array(
      'code' => 'BYR',
      'symbol' => 'руб.',
      'name' => t('Belarusian ruble'),
      'numeric_code' => '974',
      'symbol_placement' => 'after',
      'code_placement' => 'hidden',
      'decimals' => 0,
      'thousands_separator' => ' ',
      'major_unit' => t('Ruble'),
    ),
    'BZD' => array(
      'code' => 'BZD',
      'symbol' => 'BZ$',
      'name' => t('Belize Dollar'),
      'numeric_code' => '084',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Dollar'),
    ),
    'CAD' => array(
      'code' => 'CAD',
      'symbol' => 'CA$',
      'name' => t('Canadian Dollar'),
      'numeric_code' => '124',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Dollar'),
    ),
    'CDF' => array(
      'code' => 'CDF',
      'symbol' => 'CDF',
      'name' => t('Congolese Franc'),
      'numeric_code' => '976',
      'minor_unit' => t('Centime'),
      'major_unit' => t('Franc'),
    ),
    'CHF' => array(
      'code' => 'CHF',
      'symbol' => 'Fr.',
      'name' => t('Swiss Franc'),
      'rounding_step' => '0.05',
      'numeric_code' => '756',
      'thousands_separator' => "'",
      'minor_unit' => t('Rappen'),
      'major_unit' => t('Franc'),
    ),
    'CLP' => array(
      'code' => 'CLP',
      'symbol' => 'CL$',
      'name' => t('Chilean Peso'),
      'decimals' => 0,
      'numeric_code' => '152',
      'minor_unit' => t('Centavo'),
      'major_unit' => t('Peso'),
    ),
    'CNY' => array(
      'code' => 'CNY',
      'symbol' => '¥',
      'name' => t('Chinese Yuan Renminbi'),
      'numeric_code' => '156',
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'thousands_separator' => '',
      'minor_unit' => t('Fen'),
      'major_unit' => t('Yuan'),
    ),
    'COP' => array(
      'code' => 'COP',
      'symbol' => '$',
      'name' => t('Colombian Peso'),
      'decimals' => 0,
      'numeric_code' => '170',
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'thousands_separator' => '.',
      'decimal_separator' => ',',
      'minor_unit' => t('Centavo'),
      'major_unit' => t('Peso'),
    ),
    'CRC' => array(
      'code' => 'CRC',
      'symbol' => '¢',
      'name' => t('Costa Rican Colón'),
      'decimals' => 0,
      'numeric_code' => '188',
      'minor_unit' => t('Céntimo'),
      'major_unit' => t('Colón'),
    ),
    'CUC' => array(
      'code' => 'CUC',
      'symbol' => 'CUC$',
      'name' => t('Cuban Convertible Peso'),
      'minor_unit' => t('Centavo'),
      'major_unit' => t('Peso'),
    ),
    'CUP' => array(
      'code' => 'CUP',
      'symbol' => 'CU$',
      'name' => t('Cuban Peso'),
      'numeric_code' => '192',
      'minor_unit' => t('Centavo'),
      'major_unit' => t('Peso'),
    ),
    'CVE' => array(
      'code' => 'CVE',
      'symbol' => 'CV$',
      'name' => t('Cape Verdean Escudo'),
      'numeric_code' => '132',
      'minor_unit' => t('Centavo'),
      'major_unit' => t('Escudo'),
    ),
    'CZK' => array(
      'code' => 'CZK',
      'symbol' => 'Kč',
      'name' => t('Czech Republic Koruna'),
      'numeric_code' => '203',
      'thousands_separator' => ' ',
      'decimal_separator' => ',',
      'symbol_placement' => 'after',
      'code_placement' => 'hidden',
      'minor_unit' => t('Haléř'),
      'major_unit' => t('Koruna'),
    ),
    'DJF' => array(
      'code' => 'DJF',
      'symbol' => 'Fdj',
      'name' => t('Djiboutian Franc'),
      'numeric_code' => '262',
      'decimals' => 0,
      'minor_unit' => t('Centime'),
      'major_unit' => t('Franc'),
    ),
    'DKK' => array(
      'code' => 'DKK',
      'symbol' => 'kr.',
      'name' => t('Danish Krone'),
      'numeric_code' => '208',
      'thousands_separator' => ' ',
      'decimal_separator' => ',',
      'symbol_placement' => 'after',
      'code_placement' => 'hidden',
      'minor_unit' => t('Øre'),
      'major_unit' => t('Kroner'),
    ),
    'DOP' => array(
      'code' => 'DOP',
      'symbol' => 'RD$',
      'name' => t('Dominican Peso'),
      'numeric_code' => '214',
      'minor_unit' => t('Centavo'),
      'major_unit' => t('Peso'),
    ),
    'DZD' => array(
      'code' => 'DZD',
      'symbol' => 'DA',
      'name' => t('Algerian Dinar'),
      'numeric_code' => '012',
      'minor_unit' => t('Santeem'),
      'major_unit' => t('Dinar'),
    ),
    'EEK' => array(
      'code' => 'EEK',
      'symbol' => 'Ekr',
      'name' => t('Estonian Kroon'),
      'thousands_separator' => ' ',
      'decimal_separator' => ',',
      'numeric_code' => '233',
      'minor_unit' => t('Sent'),
      'major_unit' => t('Krooni'),
    ),
    'EGP' => array(
      'code' => 'EGP',
      'symbol' => 'EG£',
      'name' => t('Egyptian Pound'),
      'numeric_code' => '818',
      'minor_unit' => t('Piastr'),
      'major_unit' => t('Pound'),
    ),
    'ERN' => array(
      'code' => 'ERN',
      'symbol' => 'Nfk',
      'name' => t('Eritrean Nakfa'),
      'numeric_code' => '232',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Nakfa'),
    ),
    'ETB' => array(
      'code' => 'ETB',
      'symbol' => 'Br',
      'name' => t('Ethiopian Birr'),
      'numeric_code' => '230',
      'minor_unit' => t('Santim'),
      'major_unit' => t('Birr'),
    ),
    'EUR' => array(
      'code' => 'EUR',
      'symbol' => '€',
      'name' => t('Euro'),
      'thousands_separator' => ' ',
      'decimal_separator' => ',',
      'symbol_placement' => 'after',
      'code_placement' => 'hidden',
      'numeric_code' => '978',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Euro'),
    ),
    'FJD' => array(
      'code' => 'FJD',
      'symbol' => 'FJ$',
      'name' => t('Fijian Dollar'),
      'numeric_code' => '242',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Dollar'),
    ),
    'FKP' => array(
      'code' => 'FKP',
      'symbol' => 'FK£',
      'name' => t('Falkland Islands Pound'),
      'numeric_code' => '238',
      'minor_unit' => t('Penny'),
      'major_unit' => t('Pound'),
    ),
    'GBP' => array(
      'code' => 'GBP',
      'symbol' => '£',
      'name' => t('British Pound Sterling'),
      'numeric_code' => '826',
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Penny'),
      'major_unit' => t('Pound'),
    ),
    'GHS' => array(
      'code' => 'GHS',
      'symbol' => 'GH₵',
      'name' => t('Ghanaian Cedi'),
      'minor_unit' => t('Pesewa'),
      'major_unit' => t('Cedi'),
    ),
    'GIP' => array(
      'code' => 'GIP',
      'symbol' => 'GI£',
      'name' => t('Gibraltar Pound'),
      'numeric_code' => '292',
      'minor_unit' => t('Penny'),
      'major_unit' => t('Pound'),
    ),
    'GMD' => array(
      'code' => 'GMD',
      'symbol' => 'GMD',
      'name' => t('Gambian Dalasi'),
      'numeric_code' => '270',
      'minor_unit' => t('Butut'),
      'major_unit' => t('Dalasis'),
    ),
    'GNF' => array(
      'code' => 'GNF',
      'symbol' => 'FG',
      'name' => t('Guinean Franc'),
      'decimals' => 0,
      'numeric_code' => '324',
      'minor_unit' => t('Centime'),
      'major_unit' => t('Franc'),
    ),
    'GTQ' => array(
      'code' => 'GTQ',
      'symbol' => 'GTQ',
      'name' => t('Guatemalan Quetzal'),
      'numeric_code' => '320',
      'minor_unit' => t('Centavo'),
      'major_unit' => t('Quetzales'),
    ),
    'GYD' => array(
      'code' => 'GYD',
      'symbol' => 'GY$',
      'name' => t('Guyanaese Dollar'),
      'decimals' => 0,
      'numeric_code' => '328',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Dollar'),
    ),
    'HKD' => array(
      'code' => 'HKD',
      'symbol' => 'HK$',
      'name' => t('Hong Kong Dollar'),
      'numeric_code' => '344',
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Dollar'),
    ),
    'HNL' => array(
      'code' => 'HNL',
      'symbol' => 'HNL',
      'name' => t('Honduran Lempira'),
      'numeric_code' => '340',
      'minor_unit' => t('Centavo'),
      'major_unit' => t('Lempiras'),
    ),
    'HRK' => array(
      'code' => 'HRK',
      'symbol' => 'kn',
      'name' => t('Croatian Kuna'),
      'numeric_code' => '191',
      'minor_unit' => t('Lipa'),
      'major_unit' => t('Kuna'),
    ),
    'HTG' => array(
      'code' => 'HTG',
      'symbol' => 'HTG',
      'name' => t('Haitian Gourde'),
      'numeric_code' => '332',
      'minor_unit' => t('Centime'),
      'major_unit' => t('Gourde'),
    ),
    'HUF' => array(
      'code' => 'HUF',
      'symbol' => 'Ft',
      'name' => t('Hungarian Forint'),
      'numeric_code' => '348',
      'decimal_separator' => ',',
      'thousands_separator' => ' ',
      'decimals' => 0,
      'symbol_placement' => 'after',
      'code_placement' => 'hidden',
      'major_unit' => t('Forint'),
    ),
    'IDR' => array(
      'code' => 'IDR',
      'symbol' => 'Rp',
      'name' => t('Indonesian Rupiah'),
      'decimals' => 0,
      'numeric_code' => '360',
      'minor_unit' => t('Sen'),
      'major_unit' => t('Rupiahs'),
    ),
    'ILS' => array(
      'code' => 'ILS',
      'symbol' => '₪',
      'name' => t('Israeli New Shekel'),
      'numeric_code' => '376',
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Agora'),
      'major_unit' => t('New Shekels'),
    ),
    'INR' => array(
      'code' => 'INR',
      'symbol' => 'Rs',
      'name' => t('Indian Rupee'),
      'numeric_code' => '356',
      'minor_unit' => t('Paisa'),
      'major_unit' => t('Rupee'),
    ),
    'IRR' => array(
      'code' => 'IRR',
      'symbol' => 'ریال',
      'name' => t('Iranian Rial'),
      'decimals' => 0,
      'numeric_code' => '364',
      'symbol_placement' => 'after',
      'code_placement' => 'hidden',
      'minor_unit' => t('Rial'),
      'major_unit' => t('Toman'),
    ),
    'ISK' => array(
      'code' => 'ISK',
      'symbol' => 'Ikr',
      'name' => t('Icelandic Króna'),
      'decimals' => 0,
      'thousands_separator' => ' ',
      'numeric_code' => '352',
      'minor_unit' => t('Eyrir'),
      'major_unit' => t('Kronur'),
    ),
    'JMD' => array(
      'code' => 'JMD',
      'symbol' => 'J$',
      'name' => t('Jamaican Dollar'),
      'numeric_code' => '388',
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Dollar'),
    ),
    'JOD' => array(
      'code' => 'JOD',
      'symbol' => 'JD',
      'name' => t('Jordanian Dinar'),
      'decimals' => 3,
      'numeric_code' => '400',
      'minor_unit' => t('Piastr'),
      'major_unit' => t('Dinar'),
    ),
    'JPY' => array(
      'code' => 'JPY',
      'symbol' => '¥',
      'name' => t('Japanese Yen'),
      'decimals' => 0,
      'numeric_code' => '392',
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Sen'),
      'major_unit' => t('Yen'),
    ),
    'KES' => array(
      'code' => 'KES',
      'symbol' => 'Ksh',
      'name' => t('Kenyan Shilling'),
      'numeric_code' => '404',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Shilling'),
    ),
    'KGS' => array(
      'code' => 'KGS',
      'code_placement' => 'hidden',
      'symbol' => 'сом',
      'symbol_placement' => 'after',
      'name' => t('Kyrgyzstani Som'),
      'numeric_code' => '417',
      'thousands_separator' => '',
      'major_unit' => t('Som'),
      'minor_unit' => t('Tyiyn'),
    ),
    'KMF' => array(
      'code' => 'KMF',
      'symbol' => 'CF',
      'name' => t('Comorian Franc'),
      'decimals' => 0,
      'numeric_code' => '174',
      'minor_unit' => t('Centime'),
      'major_unit' => t('Franc'),
    ),
    'KRW' => array(
      'code' => 'KRW',
      'symbol' => '₩',
      'name' => t('South Korean Won'),
      'decimals' => 0,
      'numeric_code' => '410',
      'minor_unit' => t('Jeon'),
      'major_unit' => t('Won'),
    ),
    'KWD' => array(
      'code' => 'KWD',
      'symbol' => 'KD',
      'name' => t('Kuwaiti Dinar'),
      'decimals' => 3,
      'numeric_code' => '414',
      'minor_unit' => t('Fils'),
      'major_unit' => t('Dinar'),
    ),
    'KYD' => array(
      'code' => 'KYD',
      'symbol' => 'KY$',
      'name' => t('Cayman Islands Dollar'),
      'numeric_code' => '136',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Dollar'),
    ),
    'KZT' => array(
      'code' => 'KZT',
      'symbol' => 'тг.',
      'name' => t('Kazakhstani tenge'),
      'numeric_code' => '398',
      'thousands_separator' => ' ',
      'decimal_separator' => ',',
      'symbol_placement' => 'after',
      'code_placement' => 'hidden',
      'minor_unit' => t('Tiyn'),
      'major_unit' => t('Tenge'),
    ),
    'LAK' => array(
      'code' => 'LAK',
      'symbol' => '₭N',
      'name' => t('Laotian Kip'),
      'decimals' => 0,
      'numeric_code' => '418',
      'minor_unit' => t('Att'),
      'major_unit' => t('Kips'),
    ),
    'LBP' => array(
      'code' => 'LBP',
      'symbol' => 'LB£',
      'name' => t('Lebanese Pound'),
      'decimals' => 0,
      'numeric_code' => '422',
      'minor_unit' => t('Piastre'),
      'major_unit' => t('Pound'),
    ),
    'LKR' => array(
      'code' => 'LKR',
      'symbol' => 'SLRs',
      'name' => t('Sri Lanka Rupee'),
      'numeric_code' => '144',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Rupee'),
    ),
    'LRD' => array(
      'code' => 'LRD',
      'symbol' => 'L$',
      'name' => t('Liberian Dollar'),
      'numeric_code' => '430',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Dollar'),
    ),
    'LSL' => array(
      'code' => 'LSL',
      'symbol' => 'LSL',
      'name' => t('Lesotho Loti'),
      'numeric_code' => '426',
      'minor_unit' => t('Sente'),
      'major_unit' => t('Loti'),
    ),
    'LTL' => array(
      'code' => 'LTL',
      'symbol' => 'Lt',
      'name' => t('Lithuanian Litas'),
      'numeric_code' => '440',
      'minor_unit' => t('Centas'),
      'major_unit' => t('Litai'),
    ),
    'LVL' => array(
      'code' => 'LVL',
      'symbol' => 'Ls',
      'name' => t('Latvian Lats'),
      'numeric_code' => '428',
      'minor_unit' => t('Santims'),
      'major_unit' => t('Lati'),
    ),
    'LYD' => array(
      'code' => 'LYD',
      'symbol' => 'LD',
      'name' => t('Libyan Dinar'),
      'decimals' => 3,
      'numeric_code' => '434',
      'minor_unit' => t('Dirham'),
      'major_unit' => t('Dinar'),
    ),
    'MAD' => array(
      'code' => 'MAD',
      'symbol' => ' Dhs',
      'name' => t('Moroccan Dirham'),
      'numeric_code' => '504',
      'symbol_placement' => 'after',
      'code_placement' => 'hidden',
      'minor_unit' => t('Santimat'),
      'major_unit' => t('Dirhams'),
    ),
    'MDL' => array(
      'code' => 'MDL',
      'symbol' => 'MDL',
      'name' => t('Moldovan leu'),
      'symbol_placement' => 'after',
      'numeric_code' => '498',
      'code_placement' => 'hidden',
      'minor_unit' => t('bani'),
      'major_unit' => t('Lei'),
    ),
    'MKD' => array(
      'code' => 'MKD',
      'symbol' => 'ден',
      'name' => t('Macedonian denar'),
      'symbol_placement' => 'after',
      'numeric_code' => '807',
      'code_placement' => 'hidden',
      'minor_unit' => t('Deni'),
      'major_unit' => t('Denari'),
    ),
    'MMK' => array(
      'code' => 'MMK',
      'symbol' => 'MMK',
      'name' => t('Myanma Kyat'),
      'decimals' => 0,
      'numeric_code' => '104',
      'minor_unit' => t('Pya'),
      'major_unit' => t('Kyat'),
    ),
    'MNT' => array(
      'code' => 'MNT',
      'symbol' => '₮',
      'name' => t('Mongolian Tugrik'),
      'decimals' => 0,
      'numeric_code' => '496',
      'minor_unit' => t('Möngö'),
      'major_unit' => t('Tugriks'),
    ),
    'MOP' => array(
      'code' => 'MOP',
      'symbol' => 'MOP$',
      'name' => t('Macanese Pataca'),
      'numeric_code' => '446',
      'minor_unit' => t('Avo'),
      'major_unit' => t('Pataca'),
    ),
    'MRO' => array(
      'code' => 'MRO',
      'symbol' => 'UM',
      'name' => t('Mauritanian Ouguiya'),
      'decimals' => 0,
      'numeric_code' => '478',
      'minor_unit' => t('Khoums'),
      'major_unit' => t('Ouguiya'),
    ),
    'MTP' => array(
      'code' => 'MTP',
      'symbol' => 'MT£',
      'name' => t('Maltese Pound'),
      'minor_unit' => t('Shilling'),
      'major_unit' => t('Pound'),
    ),
    'MUR' => array(
      'code' => 'MUR',
      'symbol' => 'MURs',
      'name' => t('Mauritian Rupee'),
      'decimals' => 0,
      'numeric_code' => '480',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Rupee'),
    ),
    'MXN' => array(
      'code' => 'MXN',
      'symbol' => '$',
      'name' => t('Mexican Peso'),
      'numeric_code' => '484',
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Centavo'),
      'major_unit' => t('Peso'),
    ),
    'MYR' => array(
      'code' => 'MYR',
      'symbol' => 'RM',
      'name' => t('Malaysian Ringgit'),
      'numeric_code' => '458',
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Sen'),
      'major_unit' => t('Ringgits'),
    ),
    'MZN' => array(
      'code' => 'MZN',
      'symbol' => 'MTn',
      'name' => t('Mozambican Metical'),
      'minor_unit' => t('Centavo'),
      'major_unit' => t('Metical'),
    ),
    'NAD' => array(
      'code' => 'NAD',
      'symbol' => 'N$',
      'name' => t('Namibian Dollar'),
      'numeric_code' => '516',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Dollar'),
    ),
    'NGN' => array(
      'code' => 'NGN',
      'symbol' => '₦',
      'name' => t('Nigerian Naira'),
      'numeric_code' => '566',
      'minor_unit' => t('Kobo'),
      'major_unit' => t('Naira'),
    ),
    'NIO' => array(
      'code' => 'NIO',
      'symbol' => 'C$',
      'name' => t('Nicaraguan Cordoba Oro'),
      'numeric_code' => '558',
      'minor_unit' => t('Centavo'),
      'major_unit' => t('Cordoba'),
    ),
    'NOK' => array(
      'code' => 'NOK',
      'symbol' => 'Nkr',
      'name' => t('Norwegian Krone'),
      'thousands_separator' => ' ',
      'decimal_separator' => ',',
      'numeric_code' => '578',
      'minor_unit' => t('Øre'),
      'major_unit' => t('Krone'),
    ),
    'NPR' => array(
      'code' => 'NPR',
      'symbol' => 'NPRs',
      'name' => t('Nepalese Rupee'),
      'numeric_code' => '524',
      'minor_unit' => t('Paisa'),
      'major_unit' => t('Rupee'),
    ),
    'NZD' => array(
      'code' => 'NZD',
      'symbol' => '$',
      'name' => t('New Zealand Dollar'),
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'numeric_code' => '554',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Dollar'),
    ),
    'PAB' => array(
      'code' => 'PAB',
      'symbol' => 'B/.',
      'name' => t('Panamanian Balboa'),
      'numeric_code' => '590',
      'minor_unit' => t('Centésimo'),
      'major_unit' => t('Balboa'),
    ),
    'PEN' => array(
      'code' => 'PEN',
      'symbol' => 'S/.',
      'name' => t('Peruvian Nuevo Sol'),
      'numeric_code' => '604',
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Céntimo'),
      'major_unit' => t('Nuevos Sole'),
    ),
    'PGK' => array(
      'code' => 'PGK',
      'symbol' => 'PGK',
      'name' => t('Papua New Guinean Kina'),
      'numeric_code' => '598',
      'minor_unit' => t('Toea'),
      'major_unit' => t('Kina '),
    ),
    'PHP' => array(
      'code' => 'PHP',
      'symbol' => '₱',
      'name' => t('Philippine Peso'),
      'numeric_code' => '608',
      'minor_unit' => t('Centavo'),
      'major_unit' => t('Peso'),
    ),
    'PKR' => array(
      'code' => 'PKR',
      'symbol' => 'PKRs',
      'name' => t('Pakistani Rupee'),
      'decimals' => 0,
      'numeric_code' => '586',
      'minor_unit' => t('Paisa'),
      'major_unit' => t('Rupee'),
    ),
    'PLN' => array(
      'code' => 'PLN',
      'symbol' => 'zł',
      'name' => t('Polish Złoty'),
      'decimal_separator' => ',',
      'thousands_separator' => ' ',
      'numeric_code' => '985',
      'symbol_placement' => 'after',
      'code_placement' => 'hidden',
      'minor_unit' => t('Grosz'),
      'major_unit' => t('Złotych'),
    ),
    'PYG' => array(
      'code' => 'PYG',
      'symbol' => '₲',
      'name' => t('Paraguayan Guarani'),
      'decimals' => 0,
      'numeric_code' => '600',
      'minor_unit' => t('Céntimo'),
      'major_unit' => t('Guarani'),
    ),
    'QAR' => array(
      'code' => 'QAR',
      'symbol' => 'QR',
      'name' => t('Qatari Rial'),
      'numeric_code' => '634',
      'minor_unit' => t('Dirham'),
      'major_unit' => t('Rial'),
    ),
    'RHD' => array(
      'code' => 'RHD',
      'symbol' => 'RH$',
      'name' => t('Rhodesian Dollar'),
      'minor_unit' => t('Cent'),
      'major_unit' => t('Dollar'),
    ),
    'RON' => array(
      'code' => 'RON',
      'symbol' => 'RON',
      'name' => t('Romanian Leu'),
      'minor_unit' => t('Ban'),
      'major_unit' => t('Leu'),
    ),
    'RSD' => array(
      'code' => 'RSD',
      'symbol' => 'din.',
      'name' => t('Serbian Dinar'),
      'decimals' => 0,
      'minor_unit' => t('Para'),
      'major_unit' => t('Dinars'),
    ),
    'RUB' => array(
      'code' => 'RUB',
      'symbol' => 'руб.',
      'name' => t('Russian Ruble'),
      'thousands_separator' => ' ',
      'decimal_separator' => ',',
      'numeric_code' => '643',
      'symbol_placement' => 'after',
      'code_placement' => 'hidden',
      'minor_unit' => t('Kopek'),
      'major_unit' => t('Ruble'),
    ),
    'SAR' => array(
      'code' => 'SAR',
      'symbol' => 'SR',
      'name' => t('Saudi Riyal'),
      'numeric_code' => '682',
      'minor_unit' => t('Hallallah'),
      'major_unit' => t('Riyals'),
    ),
    'SBD' => array(
      'code' => 'SBD',
      'symbol' => 'SI$',
      'name' => t('Solomon Islands Dollar'),
      'numeric_code' => '090',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Dollar'),
    ),
    'SCR' => array(
      'code' => 'SCR',
      'symbol' => 'SRe',
      'name' => t('Seychellois Rupee'),
      'numeric_code' => '690',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Rupee'),
    ),
    'SDD' => array(
      'code' => 'SDD',
      'symbol' => 'LSd',
      'name' => t('Old Sudanese Dinar'),
      'numeric_code' => '736',
      'minor_unit' => t('None'),
      'major_unit' => t('Dinar'),
    ),
    'SEK' => array(
      'code' => 'SEK',
      'symbol' => 'kr',
      'name' => t('Swedish Krona'),
      'numeric_code' => '752',
      'thousands_separator' => ' ',
      'decimal_separator' => ',',
      'symbol_placement' => 'after',
      'code_placement' => 'hidden',
      'minor_unit' => t('Öre'),
      'major_unit' => t('Kronor'),
    ),
    'SGD' => array(
      'code' => 'SGD',
      'symbol' => 'S$',
      'name' => t('Singapore Dollar'),
      'numeric_code' => '702',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Dollar'),
    ),
    'SHP' => array(
      'code' => 'SHP',
      'symbol' => 'SH£',
      'name' => t('Saint Helena Pound'),
      'numeric_code' => '654',
      'minor_unit' => t('Penny'),
      'major_unit' => t('Pound'),
    ),
    'SLL' => array(
      'code' => 'SLL',
      'symbol' => 'Le',
      'name' => t('Sierra Leonean Leone'),
      'decimals' => 0,
      'numeric_code' => '694',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Leone'),
    ),
    'SOS' => array(
      'code' => 'SOS',
      'symbol' => 'Ssh',
      'name' => t('Somali Shilling'),
      'decimals' => 0,
      'numeric_code' => '706',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Shilling'),
    ),
    'SRD' => array(
      'code' => 'SRD',
      'symbol' => 'SR$',
      'name' => t('Surinamese Dollar'),
      'minor_unit' => t('Cent'),
      'major_unit' => t('Dollar'),
    ),
    'SRG' => array(
      'code' => 'SRG',
      'symbol' => 'Sf',
      'name' => t('Suriname Guilder'),
      'numeric_code' => '740',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Guilder'),
    ),
    'STD' => array(
      'code' => 'STD',
      'symbol' => 'Db',
      'name' => t('São Tomé and Príncipe Dobra'),
      'decimals' => 0,
      'numeric_code' => '678',
      'minor_unit' => t('Cêntimo'),
      'major_unit' => t('Dobra'),
    ),
    'SYP' => array(
      'code' => 'SYP',
      'symbol' => 'SY£',
      'name' => t('Syrian Pound'),
      'decimals' => 0,
      'numeric_code' => '760',
      'minor_unit' => t('Piastre'),
      'major_unit' => t('Pound'),
    ),
    'SZL' => array(
      'code' => 'SZL',
      'symbol' => 'SZL',
      'name' => t('Swazi Lilangeni'),
      'numeric_code' => '748',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Lilangeni'),
    ),
    'THB' => array(
      'code' => 'THB',
      'symbol' => '฿',
      'name' => t('Thai Baht'),
      'numeric_code' => '764',
      'minor_unit' => t('Satang'),
      'major_unit' => t('Baht'),
    ),
    'TND' => array(
      'code' => 'TND',
      'symbol' => 'DT',
      'name' => t('Tunisian Dinar'),
      'decimals' => 3,
      'numeric_code' => '788',
      'minor_unit' => t('Millime'),
      'major_unit' => t('Dinar'),
    ),
    'TOP' => array(
      'code' => 'TOP',
      'symbol' => 'T$',
      'name' => t('Tongan Paʻanga'),
      'numeric_code' => '776',
      'minor_unit' => t('Senit'),
      'major_unit' => t('Paʻanga'),
    ),
    'TRY' => array(
      'code' => 'TRY',
      'symbol' => 'TL',
      'name' => t('Turkish Lira'),
      'numeric_code' => '949',
      'thousands_separator' => '.',
      'decimal_separator' => ',',
      'symbol_placement' => 'after',
      'code_placement' => '',
      'minor_unit' => t('Kurus'),
      'major_unit' => t('Lira'),
    ),
    'TTD' => array(
      'code' => 'TTD',
      'symbol' => 'TT$',
      'name' => t('Trinidad and Tobago Dollar'),
      'numeric_code' => '780',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Dollar'),
    ),
    'TWD' => array(
      'code' => 'TWD',
      'symbol' => 'NT$',
      'name' => t('New Taiwan Dollar'),
      'numeric_code' => '901',
      'minor_unit' => t('Cent'),
      'major_unit' => t('New Dollar'),
    ),
    'TZS' => array(
      'code' => 'TZS',
      'symbol' => 'TSh',
      'name' => t('Tanzanian Shilling'),
      'decimals' => 0,
      'numeric_code' => '834',
      'minor_unit' => t('Senti'),
      'major_unit' => t('Shilling'),
    ),
    'UAH' => array(
      'code' => 'UAH',
      'symbol' => 'грн.',
      'name' => t('Ukrainian Hryvnia'),
      'numeric_code' => '980',
      'thousands_separator' => '',
      'decimal_separator' => '.',
      'symbol_placement' => 'after',
      'code_placement' => 'hidden',
      'minor_unit' => t('Kopiyka'),
      'major_unit' => t('Hryvnia'),
    ),
    'UGX' => array(
      'code' => 'UGX',
      'symbol' => 'USh',
      'name' => t('Ugandan Shilling'),
      'decimals' => 0,
      'numeric_code' => '800',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Shilling'),
    ),
    'USD' => array(
      'code' => 'USD',
      'symbol' => '$',
      'name' => t('United States Dollar'),
      'numeric_code' => '840',
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Dollar'),
    ),
    'UYU' => array(
      'code' => 'UYU',
      'symbol' => '$U',
      'name' => t('Uruguayan Peso'),
      'numeric_code' => '858',
      'minor_unit' => t('Centésimo'),
      'major_unit' => t('Peso'),
    ),
    'VEF' => array(
      'code' => 'VEF',
      'symbol' => 'Bs.F.',
      'name' => t('Venezuelan Bolívar Fuerte'),
      'minor_unit' => t('Céntimo'),
      'major_unit' => t('Bolivares Fuerte'),
    ),
    'VND' => array(
      'code' => 'VND',
      'symbol' => 'đ',
      'name' => t('Vietnamese Dong'),
      'decimals' => 0,
      'thousands_separator' => '.',
      'symbol_placement' => 'after',
      'symbol_spacer' => '',
      'code_placement' => 'hidden',
      'numeric_code' => '704',
      'minor_unit' => t('Hà'),
      'major_unit' => t('Dong'),
    ),
    'VUV' => array(
      'code' => 'VUV',
      'symbol' => 'VT',
      'name' => t('Vanuatu Vatu'),
      'decimals' => 0,
      'numeric_code' => '548',
      'major_unit' => t('Vatu'),
    ),
    'WST' => array(
      'code' => 'WST',
      'symbol' => 'WS$',
      'name' => t('Samoan Tala'),
      'numeric_code' => '882',
      'minor_unit' => t('Sene'),
      'major_unit' => t('Tala'),
    ),
    'XAF' => array(
      'code' => 'XAF',
      'symbol' => 'FCFA',
      'name' => t('CFA Franc BEAC'),
      'decimals' => 0,
      'numeric_code' => '950',
      'minor_unit' => t('Centime'),
      'major_unit' => t('Franc'),
    ),
    'XCD' => array(
      'code' => 'XCD',
      'symbol' => 'EC$',
      'name' => t('East Caribbean Dollar'),
      'numeric_code' => '951',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Dollar'),
    ),
    'XOF' => array(
      'code' => 'XOF',
      'symbol' => 'CFA',
      'name' => t('CFA Franc BCEAO'),
      'decimals' => 0,
      'numeric_code' => '952',
      'minor_unit' => t('Centime'),
      'major_unit' => t('Franc'),
    ),
    'XPF' => array(
      'code' => 'XPF',
      'symbol' => 'CFPF',
      'name' => t('CFP Franc'),
      'decimals' => 0,
      'numeric_code' => '953',
      'minor_unit' => t('Centime'),
      'major_unit' => t('Franc'),
    ),
    'YER' => array(
      'code' => 'YER',
      'symbol' => 'YR',
      'name' => t('Yemeni Rial'),
      'decimals' => 0,
      'numeric_code' => '886',
      'minor_unit' => t('Fils'),
      'major_unit' => t('Rial'),
    ),
    'ZAR' => array(
      'code' => 'ZAR',
      'symbol' => 'R',
      'name' => t('South African Rand'),
      'numeric_code' => '710',
      'symbol_placement' => 'before',
      'code_placement' => 'hidden',
      'minor_unit' => t('Cent'),
      'major_unit' => t('Rand'),
    ),
    'ZMK' => array(
      'code' => 'ZMK',
      'symbol' => 'ZK',
      'name' => t('Zambian Kwacha'),
      'decimals' => 0,
      'numeric_code' => '894',
      'minor_unit' => t('Ngwee'),
      'major_unit' => t('Kwacha'),
    ),
  );
}
