<?php

function fernweh_payment_add_modal_callback($js = FALSE) {
    global $user;
    if ($js) {
        // Include your ctools crap here
        ctools_include('node.pages', 'node', '');
        ctools_include('modal');
        ctools_include('ajax');

        // Create a blank node object here. You can also set values for your custom fields here as well.
        $node = (object) array(
            'uid' => $user->uid,
            'name' => (isset($user->name) ? $user->name : ''),
            'type' => 'payment',
            'language' => LANGUAGE_NONE,
        );

        $form_state = array(
            'title' => t('Make Payment'),
            'ajax' => TRUE,
        );

        $form_state['build_info']['args'] = array($node);

        $output = ctools_modal_form_wrapper('payment_node_form', $form_state);

        if (!empty($form_state['executed'])) {
            $output = array();
            // Close the modal
            $output[] = ctools_modal_command_dismiss();
            $output[] = ctools_ajax_command_reload();
        }

        print ajax_render($output);
        drupal_exit();
    }
    else {
        return drupal_get_form('payment_node_form');
    }
}

function fernweh_payment_edit_modal_callback($js = FALSE, $nodeId) {
    if ($js) {
        ctools_include('node.pages', 'node', '');
        ctools_include('modal');
        ctools_include('ajax');

        // Create a blank node object here. You can also set values for your custom fields here as well.
        $node = node_load($nodeId);

        $form_state = array(
            'title' => t('Edit payment'),
            'ajax' => TRUE,
        );

        $form_state['build_info']['args'] = array($node);

        $output = ctools_modal_form_wrapper('payment_node_form', $form_state);

        if (!empty($form_state['executed'])) {
            $output = array();
            // Close the modal
            $output[] = ctools_modal_command_dismiss();
            $output[] =  ctools_ajax_command_reload();
        }

        print ajax_render($output);
        drupal_exit();
    }
    else {
        return drupal_get_form('payment_node_form');
    }
}

function fernweh_payment_delete_modal_callback($js = FALSE, $nodeId) {

    if ($js) {
        ctools_include('ajax');
        ctools_include('modal');
        ctools_add_js('ajax-responder');

        $form_state = array(
            'ajax' => TRUE,
            'title' => t('Delete Payment'),
        );

        $output = ctools_modal_form_wrapper('payment_delete_form', $form_state);

        if (!empty($form_state['ajax_commands'])) {
            $output = $form_state['ajax_commands'];
        }

        print ajax_render($output);
        drupal_exit();
    }
    else {
        return drupal_get_form('payment_delete_form');
    }
}

function payment_delete_form($form, $form_state) {

    $form = array();
    $form['delete_message']['#markup'] = '<h2>Are you sure you want to Delete?</h2>';
    $form['id'] = array(
        '#type' => 'hidden',
        '#value' => arg(3),
    );

    $form['actions']['cancel'] = array(
        '#prefix' => '<div class="popup-footer-wrapper">',
        '#markup' => l(t('Cancel'), '#', array(
                'attributes' => array(
                    'class' => 'ctools-close-modal modal-cancel-btn'
                ),
                'external' => TRUE
            )
        )
    );
    $form['submit'] = array(
        '#type' => 'submit',
        '#value' => t('Delete'),
        '#suffix' => '</div>'
    );
    return $form;
}

function payment_delete_form_submit(&$form, &$form_state) {
    $payment = node_load($form_state['values']['id']);
    if (is_object($payment)) {
        _fernweh_alter_payment_delete_form_submit_extend($payment); // Update account outstanding balance
        node_delete($payment->nid);
        $form_state['ajax_commands'][] = ctools_modal_command_dismiss();
        drupal_set_message(t('Payment information deleted successfully.'));
    }
    else {
        drupal_set_message(t('Some error occurred while deleting payment.', 'error'));
    }
    $form_state['ajax_commands'][] =  ctools_ajax_command_reload();
}
