<?php

/**
 * @file
 * Bulk export of heartbeat objects generated by Bulk export module.
 */

/**
 * Implements hook_heartbeat_stream_info().
 */
function heartbeat_defaults_heartbeat_stream_info() {

  $heartbeatstreams = array();

  /**
   * useractivity
   */
  $heartbeatstream = new HeartbeatStreamConfig();
  $heartbeatstream->disabled = FALSE; /* Edit this to true to make a default heartbeatstream disabled initially */
  $heartbeatstream->api_version = 1;
  $heartbeatstream->class = 'useractivity';
  $heartbeatstream->real_class = 'useractivity';
  $heartbeatstream->name = 'User activity';
  $heartbeatstream->module = 'heartbeat_defaults';
  $heartbeatstream->title = 'User activity';
  $heartbeatstream->path = 'streams/useractivity.inc';
  $heartbeatstream->settings = array(
    'settings__active_tab' => 'edit-settings-fs-blocks',
    'messages_denied' => array(
    ),
    'skip_active_user' => 0,
    'show_message_times' => 1,
    'show_message_times_grouped' => 1,
    'poll_messages' => '0',
    'num_load_max' => '100',
    'grouping_seconds' => '7200',
    'has_block' => 1,
    'block_items_max' => '5',
    'block_show_pager' => '1',
    'block_view_mode' => 'default',
    'stream_path' => 'useractivity',
    'stream_profile_path' => 'useractivity',
    'page_items_max' => '8',
    'page_show_pager' => 0,
    'page_pager_ajax' => 0,
    'page_view_mode' => 'default',
    'show_status_form' => '0',
    'shoutbox' => 0,
  );
  $heartbeatstream->variables = array();
  $heartbeatstreams['useractivity'] = $heartbeatstream;

  /**
   * siteactivity
   */
  $heartbeatstream = new HeartbeatStreamConfig();
  $heartbeatstream->disabled = FALSE; /* Edit this to true to make a default heartbeatstream disabled initially */
  $heartbeatstream->api_version = 1;
  $heartbeatstream->class = 'siteactivity';
  $heartbeatstream->real_class = 'siteactivity';
  $heartbeatstream->name = 'Site activity';
  $heartbeatstream->module = 'heartbeat_defaults';
  $heartbeatstream->title = 'Site activity';
  $heartbeatstream->path = 'streams/siteactivity.inc';
  $heartbeatstream->settings = array(
    'settings__active_tab' => 'edit-settings-fs-blocks',
    'messages_denied' => array(
    ),
    'skip_active_user' => 0,
    'show_message_times' => 1,
    'show_message_times_grouped' => 1,
    'poll_messages' => '0',
    'num_load_max' => '40',
    'grouping_seconds' => '7200',
    'has_block' => 1,
    'block_items_max' => '5',
    'block_show_pager' => '1',
    'block_view_mode' => 'default',
    'stream_path' => 'heartbeat/siteactivity',
    'stream_profile_path' => '',
    'page_items_max' => '8',
    'page_show_pager' => 1,
    'page_pager_ajax' => 1,
    'page_view_mode' => 'full',
    'show_status_form' => '0',
    'shoutbox' => 0,
  );
  $heartbeatstream->variables = array();
  $heartbeatstreams['siteactivity'] = $heartbeatstream;

  /**
   * relationsactivity
   */
  $heartbeatstream = new HeartbeatStreamConfig();
  $heartbeatstream->disabled = FALSE; /* Edit this to true to make a default heartbeatstream disabled initially */
  $heartbeatstream->api_version = 1;
  $heartbeatstream->class = 'relationsactivity';
  $heartbeatstream->real_class = 'relationsactivity';
  $heartbeatstream->name = 'User relations activity';
  $heartbeatstream->module = 'heartbeat_defaults';
  $heartbeatstream->title = 'User relations activity';
  $heartbeatstream->path = 'streams/relationsactivity.inc';
  $heartbeatstream->settings = array(
    'settings__active_tab' => 'edit-settings-fs-blocks',
    'messages_denied' => array(
    ),
    'skip_active_user' => 0,
    'show_message_times' => 1,
    'show_message_times_grouped' => 1,
    'poll_messages' => '0',
    'num_load_max' => '30',
    'grouping_seconds' => '7200',
    'has_block' => 1,
    'block_items_max' => '5',
    'block_show_pager' => '1',
    'block_view_mode' => 'default',
    'stream_path' => 'heartbeat/relations',
    'stream_profile_path' => 'friends-activity',
    'page_items_max' => '8',
    'page_show_pager' => 1,
    'page_pager_ajax' => 1,
    'page_view_mode' => 'full',
    'show_status_form' => '0',
    'shoutbox' => 0,
  );
  $heartbeatstream->variables = array();
  $heartbeatstreams['relationsactivity'] = $heartbeatstream;

  /**
   * nodeactivity
   */
  $heartbeatstream = new HeartbeatStreamConfig();
  $heartbeatstream->disabled = FALSE; /* Edit this to true to make a default heartbeatstream disabled initially */
  $heartbeatstream->api_version = 1;
  $heartbeatstream->class = 'nodeactivity';
  $heartbeatstream->real_class = 'nodeactivity';
  $heartbeatstream->name = 'Node activity';
  $heartbeatstream->module = 'heartbeat_defaults';
  $heartbeatstream->title = 'Node activity';
  $heartbeatstream->path = 'streams/nodeactivity.inc';
  $heartbeatstream->settings = array(
    'settings__active_tab' => 'edit-settings-fs-blocks',
    'messages_denied' => array(
    ),
    'skip_active_user' => 0,
    'show_message_times' => 1,
    'show_message_times_grouped' => 1,
    'poll_messages' => '60',
    'num_load_max' => '20',
    'grouping_seconds' => '7200',
    'has_block' => 1,
    'block_items_max' => '5',
    'block_show_pager' => '1',
    'block_view_mode' => 'default',
    'stream_path' => 'heartbeat/node-activity',
    'stream_profile_path' => '',
    'page_items_max' => '8',
    'page_show_pager' => 0,
    'page_pager_ajax' => 0,
    'page_view_mode' => 'full',
    'show_status_form' => '0',
    'shoutbox' => 0,
  );
  $heartbeatstream->variables = array();
  $heartbeatstreams['nodeactivity'] = $heartbeatstream;

  /**
   * tweet_siteactivity (extending siteactivity)
   */
  $heartbeatstream = new HeartbeatStreamConfig();
  $heartbeatstream->disabled = FALSE; /* Edit this to true to make a default heartbeatstream disabled initially */
  $heartbeatstream->api_version = 1;
  $heartbeatstream->class = 'tweet_siteactivity';
  $heartbeatstream->real_class = 'siteactivity';
  $heartbeatstream->name = 'Site activity';
  $heartbeatstream->module = 'heartbeat_defaults';
  $heartbeatstream->title = 'Site activity with activity form';
  $heartbeatstream->path = 'streams/siteactivity.inc';
  $heartbeatstream->settings = array(
    'settings__active_tab' => 'edit-settings-fs-blocks',
    'messages_denied' => array(
    ),
    'skip_active_user' => 0,
    'show_message_times' => 1,
    'show_message_times_grouped' => 1,
    'poll_messages' => '30',
    'num_load_max' => '30',
    'grouping_seconds' => '7200',
    'has_block' => 1,
    'block_items_max' => '5',
    'block_show_pager' => '1',
    'block_view_mode' => 'default',
    'stream_path' => 'heartbeat/tweet',
    'stream_profile_path' => '',
    'page_items_max' => '8',
    'page_show_pager' => 1,
    'page_pager_ajax' => 1,
    'page_view_mode' => 'full',
    'show_status_form' => 'heartbeat_tweet',
    'shoutbox' => 0,
  );
  $heartbeatstream->variables = array();
  $heartbeatstreams['tweet_siteactivity'] = $heartbeatstream;

  return $heartbeatstreams;

}

/**
 * Implements hook_heartbeat_template_info().
 */
function heartbeat_defaults_heartbeat_template_info() {

  $heartbeatmessagetemplates = array();

  /**
   * heartbeat_add_comment
   */
  if (module_exists('comment')) {

    $heartbeatmessagetemplate = new HeartbeatMessageTemplate();
    $heartbeatmessagetemplate->disabled = FALSE; /* Edit this to true to make a default heartbeatmessagetemplate disabled initially */
    $heartbeatmessagetemplate->api_version = 1;
    $heartbeatmessagetemplate->message_id = 'heartbeat_add_comment';
    $heartbeatmessagetemplate->description = 'user replied on some content';
    $heartbeatmessagetemplate->message = '<span>!username replied on !title:</span><blockquote><div>!comment</div></blockquote>';
    $heartbeatmessagetemplate->message_concat = '%username% replied on !title.';
    $heartbeatmessagetemplate->perms = 2;
    $heartbeatmessagetemplate->group_type = 'summary';
    $heartbeatmessagetemplate->concat_args = array(
      'group_by' => 'node',
      'group_target' => 'username',
      'group_by_target' => 'title',
      'group_num_max' => '5',
      'merge_separator' => ', ',
      'merge_end_separator' => ' and ',
      'roles' => array(
        1 => 0,
        2 => 0,
        3 => 0,
        4 => 0,
        5 => 0,
      ),
    );
    $heartbeatmessagetemplate->variables = array(
      '!username' => '',
      '!title' => '',
      '!comment' => '',
    );
    $heartbeatmessagetemplate->attachments = array(
      'buttons' => array(
        'weight' => array(
          'activitycomments' => '-9',
          'flagattachment:like' => '0',
        ),
        'settings' => array(
          'activitycomments' => array(
            'activitycomments_node' => 0,
          ),
        ),
        'enabled' => array(
          'activitycomments' => 0,
          'flagattachment:like' => 0,
        ),
      ),
      'content' => array(
        'weight' => array(
          'activitycomments' => '-9',
          'flagattachment:like' => '0',
        ),
        'enabled' => array(
          'activitycomments' => 0,
          'flagattachment:like' => 0,
        ),
      ),
    );
    $heartbeatmessagetemplates['heartbeat_add_comment'] = $heartbeatmessagetemplate;

  }

  /**
   * heartbeat_add_node
   */
  $heartbeatmessagetemplate = new HeartbeatMessageTemplate();
  $heartbeatmessagetemplate->disabled = FALSE; /* Edit this to true to make a default heartbeatmessagetemplate disabled initially */
  $heartbeatmessagetemplate->api_version = 1;
  $heartbeatmessagetemplate->message_id = 'heartbeat_add_node';
  $heartbeatmessagetemplate->description = 'User adds a node, save user activity';
  $heartbeatmessagetemplate->message = '!username has added !node_type !node_title.';
  $heartbeatmessagetemplate->message_concat = '!username has added the following !types: %node_title%.';
  $heartbeatmessagetemplate->perms = 4;
  $heartbeatmessagetemplate->group_type = 'summary';
  $heartbeatmessagetemplate->concat_args = array(
    'group_by' => 'user',
    'group_target' => 'node_title',
    'group_by_target' => 'username',
    'group_num_max' => '4',
    'merge_separator' => ', ',
    'merge_end_separator' => ' and ',
    'roles' => array(
      1 => 0,
      2 => 0,
      3 => 0,
      4 => 0,
      5 => 0,
    ),
  );
  $heartbeatmessagetemplate->variables = array(
    '!username' => '',
    '!node_type' => '',
    '!node_title' => '',
    '!types' => '',
  );
  $heartbeatmessagetemplate->attachments = array(
    'buttons' => array(
      'weight' => array(
        'flagattachment:like' => '-10',
        'activitycomments' => '-9',
      ),
      'settings' => array(
        'activitycomments' => array(
          'activitycomments_node' => 1,
        ),
      ),
      'enabled' => array(
        'flagattachment:like' => 'flagattachment:like',
        'activitycomments' => 'activitycomments',
      ),
    ),
    'content' => array(
      'weight' => array(
        'flagattachment:like' => '-10',
        'activitycomments' => '-9',
      ),
      'enabled' => array(
        'flagattachment:like' => 'flagattachment:like',
        'activitycomments' => 'activitycomments',
      ),
    ),
  );
  $heartbeatmessagetemplates['heartbeat_add_node'] = $heartbeatmessagetemplate;

  /**
   * heartbeat_edit_account
   */
  $heartbeatmessagetemplate = new HeartbeatMessageTemplate();
  $heartbeatmessagetemplate->disabled = FALSE; /* Edit this to true to make a default heartbeatmessagetemplate disabled initially */
  $heartbeatmessagetemplate->api_version = 1;
  $heartbeatmessagetemplate->message_id = 'heartbeat_edit_account';
  $heartbeatmessagetemplate->description = 'user changed his/her account';
  $heartbeatmessagetemplate->message = '!username\'s personal account page has been changed.';
  $heartbeatmessagetemplate->message_concat = 'The personal account page of %username% has been changed.';
  $heartbeatmessagetemplate->perms = 4;
  $heartbeatmessagetemplate->group_type = 'summary';
  $heartbeatmessagetemplate->concat_args = array(
    'group_by' => 'node',
    'group_target' => 'username',
    'group_by_target' => '',
    'group_num_max' => '4',
    'merge_separator' => ', ',
    'merge_end_separator' => ' and ',
    'roles' => array(
      1 => 0,
      2 => 0,
      3 => 0,
      4 => 0,
      5 => 0,
    ),
  );
  $heartbeatmessagetemplate->variables = array(
    '!username' => '',
  );
  $heartbeatmessagetemplate->attachments = array(
    'buttons' => array(
      'weight' => array(
        'activitycomments' => '-9',
        'flagattachment:like' => '0',
      ),
      'settings' => array(
        'activitycomments' => array(
          'activitycomments_node' => 0,
        ),
      ),
      'enabled' => array(
        'activitycomments' => 'activitycomments',
        'flagattachment:like' => 0,
      ),
    ),
    'content' => array(
      'weight' => array(
        'activitycomments' => '-9',
        'flagattachment:like' => '0',
      ),
      'enabled' => array(
        'activitycomments' => 'activitycomments',
        'flagattachment:like' => 0,
      ),
    ),
  );
  $heartbeatmessagetemplates['heartbeat_edit_account'] = $heartbeatmessagetemplate;

  /**
   * heartbeat_edit_node
   */
  $heartbeatmessagetemplate = new HeartbeatMessageTemplate();
  $heartbeatmessagetemplate->disabled = FALSE; /* Edit this to true to make a default heartbeatmessagetemplate disabled initially */
  $heartbeatmessagetemplate->api_version = 1;
  $heartbeatmessagetemplate->message_id = 'heartbeat_edit_node';
  $heartbeatmessagetemplate->description = 'When editing a node, log the users activity';
  $heartbeatmessagetemplate->message = '!username has updated !node_type "!node_title".';
  $heartbeatmessagetemplate->message_concat = '!username has updated %node_title%.';
  $heartbeatmessagetemplate->perms = 4;
  $heartbeatmessagetemplate->group_type = 'summary';
  $heartbeatmessagetemplate->concat_args = array(
    'group_by' => 'user',
    'group_target' => 'node_title',
    'group_by_target' => '',
    'group_num_max' => '4',
    'merge_separator' => ', ',
    'merge_end_separator' => ' and ',
    'roles' => array(
      1 => 0,
      2 => 0,
      3 => 0,
      4 => 0,
      5 => 0,
    ),
  );
  $heartbeatmessagetemplate->variables = array(
    '!username' => '',
    '!node_type' => '',
    '!node_title' => '',
  );
  $heartbeatmessagetemplate->attachments = array(
    'buttons' => array(
      'weight' => array(
        'flagattachment:like' => '-9',
        'activitycomments' => '-8',
      ),
      'settings' => array(
        'activitycomments' => array(
          'activitycomments_node' => 1,
        ),
      ),
      'enabled' => array(
        'flagattachment:like' => 'flagattachment:like',
        'activitycomments' => 'activitycomments',
      ),
    ),
    'content' => array(
      'weight' => array(
        'flagattachment:like' => '-9',
        'activitycomments' => '-8',
      ),
      'enabled' => array(
        'flagattachment:like' => 'flagattachment:like',
        'activitycomments' => 'activitycomments',
      ),
    ),
  );
  $heartbeatmessagetemplates['heartbeat_edit_node'] = $heartbeatmessagetemplate;

  /**
   * heartbeat_become_friends.
   */
  if (module_exists('flag_friend') || module_exists('user_relationships')) {

    $heartbeatmessagetemplate = new HeartbeatMessageTemplate();
    $heartbeatmessagetemplate->disabled = FALSE; /* Edit this to true to make a default heartbeatmessagetemplate disabled initially */
    $heartbeatmessagetemplate->api_version = 1;
    $heartbeatmessagetemplate->message_id = 'heartbeat_become_friends';
    $heartbeatmessagetemplate->description = 'When a user becomes friends with another user (UR)';
    $heartbeatmessagetemplate->message = '!username is now friends with !user2.';
    $heartbeatmessagetemplate->message_concat = '!username is now friends with %user2%.';
    $heartbeatmessagetemplate->perms = 4;
    $heartbeatmessagetemplate->group_type = 'summary';
    $heartbeatmessagetemplate->concat_args = array(
      'group_by' => 'user-user',
      'group_target' => 'user2',
      'group_by_target' => 'username',
      'group_num_max' => '4',
      'merge_separator' => ', ',
      'merge_end_separator' => ' and ',
    );
    $heartbeatmessagetemplate->variables = array(
      '!username' => '',
      '!user2' => '',
    );
    $heartbeatmessagetemplate->attachments = array(
      'buttons' => array(
        'weight' => array(
          'activitycomments' => -9,
          'flagattachment:like' => -10,
        ),
        'settings' => array(
          'activitycomments' => array(
            'activitycomments_node' => 0,
          ),
        ),
        'enabled' => array(
          'activitycomments' => 'activitycomments',
          'flagattachment:like' => 'flagattachment:like',
        ),
      ),
      'content' => array(
        'weight' => array(
          'activitycomments' => -9,
          'flagattachment:like' => -10,
        ),
        'enabled' => array(
          'activitycomments' => 'activitycomments',
          'flagattachment:like' => 'flagattachment:like',
        ),
      ),
    );
    $heartbeatmessagetemplates['heartbeat_become_friends'] = $heartbeatmessagetemplate;

  }

  /**
   * heartbeat_tweet
   */
  $heartbeatmessagetemplate = new HeartbeatMessageTemplate();
  $heartbeatmessagetemplate->disabled = FALSE; /* Edit this to true to make a default heartbeatmessagetemplate disabled initially */
  $heartbeatmessagetemplate->api_version = 1;
  $heartbeatmessagetemplate->message_id = 'heartbeat_tweet';
  $heartbeatmessagetemplate->description = 'A custom message or tweet';
  $heartbeatmessagetemplate->message = '!username !message';
  $heartbeatmessagetemplate->message_concat = '';
  $heartbeatmessagetemplate->perms = 2;
  $heartbeatmessagetemplate->group_type = 'single';
  $heartbeatmessagetemplate->concat_args = array(
    'group_by' => 'none',
    'group_target' => '',
    'group_by_target' => '',
    'group_num_max' => '',
    'merge_separator' => '',
    'merge_end_separator' => '',
    'roles' => array(
      1 => 0,
      2 => 0,
      3 => 0,
      4 => 0,
      5 => 0,
    ),
  );
  $heartbeatmessagetemplate->variables = array(
    '!username' => '',
    '!message' => '',
  );
  $heartbeatmessagetemplate->attachments = array(
    'buttons' => array(
      'weight' => array(
        'activitycomments' => -9,
      ),
      'settings' => array(
        'activitycomments' => array(
          'activitycomments_node' => 0,
        ),
      ),
      'enabled' => array(
        'activitycomments' => 'activitycomments',
      ),
    ),
    'content' => array(
      'weight' => array(
        'activitycomments' => -9,
      ),
      'enabled' => array(
        'activitycomments' => 'activitycomments',
      ),
    ),
  );
  $heartbeatmessagetemplates['heartbeat_tweet'] = $heartbeatmessagetemplate;

  return $heartbeatmessagetemplates;

}