<?php
/**
 * Created by PhpStorm.
 * User: sunil
 * Date: 13/4/15
 * Time: 2:35 PM
 */

function fernweh_lead_delete_modal_callback($js = FALSE, $nodeId) {
    if ($js) {

        ctools_include('modal');
        ctools_include('ajax');
        ctools_add_js('ajax-responder');

        $form_state = array(
            'title' => t('Delete Lead'),
            'ajax' => TRUE,
        );


        $output = ctools_modal_form_wrapper('lead_delete_form', $form_state);

        if (!empty($form_state['ajax_commands'])) {
            $output = $form_state['ajax_commands'];
        }

        print ajax_render($output);
        drupal_exit();

    }
    else {
        return drupal_get_form('lead_delete_form');
    }
}

function lead_delete_form($form, $form_state) {
    $form = array();
    $form['delete_message']['#markup'] = '<h2>Are you sure you want to Delete?</h2>';
    $form['id'] = array(
        '#type' => 'hidden',
        '#value' => arg(3),
    );

    $form['actions']['cancel'] = array(
        '#prefix' => '<div class="popup-footer-wrapper">',
        '#markup' => l(t('Cancel'), '#', array(
                'attributes' => array(
                    'class' => 'ctools-close-modal modal-cancel-btn'
                ),
                'external' => TRUE
            )
        )
    );
    $form['submit'] = array(
        '#type' => 'submit',
        '#value' => t('Delete'),
        '#suffix' => '</div>'
    );
    return $form;
}

function lead_delete_form_submit(&$form, &$form_state) {

    $lead = commerce_product_load($form_state['values']['id']);
    if (is_object($lead)) {
        $lead->status = 0;
        commerce_product_save($lead);
        $form_state['ajax_commands'][] = ctools_modal_command_dismiss();
        drupal_set_message(t('Lead information deleted successfully.'));
    }
    else {
        drupal_set_message(t('Some error occurred while deleting lead.', 'error'));
    }
    $form_state['ajax_commands'][] = ctools_ajax_command_redirect('leads',1000);

}
