<?php

/**
 * @file
 * Contains Modal Popup Callback for credit lead_statuss
 */

/**
 * Callback function for adding a credit lead_status
 * @param type $js
 * @return type
 */
function fernweh_lead_status_add_modal_callback($js = FALSE) {
  if ($js) {
    // Include your ctools crap here
    ctools_include('taxonomy.admin', 'taxonomy', '');
    ctools_include('modal');
    ctools_include('ajax');

    // Create a blank term object here. You can also set values for your custom fields here as well.
    $vocabulary = taxonomy_vocabulary_load(5); // 5 is vocabulary id for credit lead_status taxonomy

    $form_state = array(
      'title' => t('Add New Credit Card'),
      'ajax' => TRUE,
    );

    $vocabulary->name = '';
    $vocabulary->description = '';
    $form_state['build_info']['args'] = array($vocabulary);

    $output = ctools_modal_form_wrapper('taxonomy_form_term', $form_state);

    if (!empty($form_state['executed'])) {
      $output = array();
      $output[] = ctools_modal_command_dismiss();
      $output[] = ctools_ajax_command_redirect('lead-status', 1000);
    }

    print ajax_render($output);
    drupal_exit();
  }
  else {
    module_load_include('inc', 'taxonomy', 'taxonomy.admin');
    $vocabulary = taxonomy_vocabulary_load(5);
    $vocabulary->name = '';
    $vocabulary->description = '';
    return drupal_get_form('taxonomy_form_term', $vocabulary);
  }
}

/**
 * Callback function to edit lead_status
 * @param type $js
 * @param type $termId
 * @return type
 */
function fernweh_lead_status_edit_modal_callback($js = FALSE, $termId) {
  if ($js) {
    ctools_include('taxonomy.admin', 'taxonomy', '');
    ctools_include('modal');
    ctools_include('ajax');

    $term = taxonomy_term_load($termId);

    $form_state = array(
      'title' => t('Edit Lead Status Details'),
      'ajax' => TRUE,
    );

    $form_state['build_info']['args'] = array($term);

    $output = ctools_modal_form_wrapper('taxonomy_form_term', $form_state);

    if (!empty($form_state['executed'])) {
      $output = array();
      $output[] = ctools_modal_command_dismiss();
      $output[] = ctools_ajax_command_redirect('lead-status', 1000);
    }

    print ajax_render($output);
    drupal_exit();
  }
  else {
    module_load_include('inc', 'taxonomy', 'taxonomy.admin');
    $term = taxonomy_term_load($termId);
    return drupal_get_form('taxonomy_form_term', $term);
  }
}

/**
 * Callbak function to delete the lead_status
 * @param type $js
 * @param type $termId
 * @return type
 */
function fernweh_lead_status_delete_modal_callback($js = FALSE, $termId) {
  if ($js) {
    ctools_include('ajax');
    ctools_include('modal');
    ctools_add_js('ajax-responder');

    $form_state = array(
      'ajax' => TRUE,
      'title' => t('Delete Lead Status'),
    );

    $output = ctools_modal_form_wrapper('lead_status_delete_form', $form_state);

    if (!empty($form_state['ajax_commands'])) {
      $output = $form_state['ajax_commands'];
    }

    print ajax_render($output);
    drupal_exit();
  }
  else {
    return drupal_get_form('lead_status_delete_form');
  }
}

/**
 * Delete lead_status form
 * @param type $form
 * @param type $form_state
 * @return string
 */
function lead_status_delete_form($form, $form_state) {
  $form = array();
  $form['delete_message']['#markup'] = '<h2>Are you sure you want to Delete?</h2>';
  $form['id'] = array(
    '#type' => 'hidden',
    '#value' => arg(3),
  );

  $form['actions']['cancel'] = array(
    '#markup' => l(t('Cancel'), '#', array(
      'attributes' => array(
        'class' => 'ctools-close-modal modal-cancel-btn'
      ),
      'external' => TRUE
        )
    )
  );
  $form['submit'] = array(
    '#type' => 'submit',
    '#value' => t('Delete'),
  );
  return $form;
}

/**
 * Delete lead_status submit function
 * @param type $form
 * @param type $form_state
 */
function lead_status_delete_form_submit(&$form, &$form_state) {
  $term = taxonomy_term_load($form_state['values']['id']);
  if (is_object($term)) {
    $term->status = 0;
    taxonomy_term_save($term);
    $form_state['ajax_commands'][] = ctools_modal_command_dismiss();
    drupal_set_message(t('Lead status deleted successfully.'));
  }
  else {
    drupal_set_message(t('Some error occurred while deleting lead status.', 'error'));
  }
  $form_state['ajax_commands'][] = ctools_ajax_command_redirect('lead-status');
}

/**
 * Callback function to view the lead_status details
 * @param type $js
 * @param type $termId
 * @return type
 */
function fernweh_lead_status_view_modal_callback($js = FALSE, $termId) {
  if ($js) {
    ctools_include('ajax');
    ctools_include('modal');

    $form_state = array(
      'ajax' => TRUE,
      'title' => t('Lead Status Details'),
    );

    $output = ctools_modal_form_wrapper('lead_status_view_form', $form_state);

    if (!empty($form_state['ajax_commands'])) {
      $output = $form_state['ajax_commands'];
    }

    print ajax_render($output);
    drupal_exit();
  }
  else {
    return drupal_get_form('lead_status_delete_form');
  }
}

/**
 * Form to display lead_status basic details
 * @param type $form
 * @param type $form_state
 * @return type
 */
function lead_status_view_form($form, $form_state) {
  $lead_status = taxonomy_term_load(arg(3));
  $lead_statusHtml = '';
  $lead_statusHtml .= '<ul>';
//  if (is_object($lead_status)) {
//    $lead_statusHtml .= ' <li><span>Card Number: </span>' . $lead_status->field_lead_status_number[LANGUAGE_NONE][0]['value'] . '</li>';
//    $lead_statusHtml .= ' <li><span>Bank Name: </span>' . $lead_status->name . '</li>';
//    $lead_statusHtml .= ' <li><span>Type: </span>' . $lead_status->field_lead_status_type[LANGUAGE_NONE][0]['value'] . '</li>';
//    $lead_statusHtml .= ' <li><span>Available Credit: </span>' . $lead_status->field_lead_status_available_credit[LANGUAGE_NONE][0]['value'] . '</li>';
//    $lead_statusHtml .= ' <li><span>Credit Limit: </span>' . $lead_status->field_lead_status_credit_limit[LANGUAGE_NONE][0]['value'] . '</li>';
//  }
//  else {
//    $lead_statusHtml .= '<li>' . t('No information is available for this lead_status.') . '</li>';
//  }

  $lead_statusHtml .= '<li>' . t('No information is available for this lead_status.') . '</li>';

  $lead_statusHtml .= '</ul>';

  $form = array();
  $form['name'] = array(
    '#markup' => $lead_statusHtml,
  );
  $form['actions']['close'] = array(
    '#markup' => l(t('Close'), '#', array(
      'attributes' => array(
        'class' => 'ctools-close-modal modal-cancel-btn'
      ),
      'external' => TRUE
        )
    )
  );
  return $form;
}
