<?php

/**
 * @file
 * Template overrides as well as (pre-)process and alter hooks for the
 * Fernweh theme.
 */
function fernweh_menu_link(array $variables) {
  $element = $variables['element'];
  $sub_menu = '';

  if ($element['#below']) {
    $sub_menu = drupal_render($element['#below']);
  }

  switch ($element['#original_link']['mlid']) {
    case 310:
      $element['#localized_options']['attributes']['class'] = array('fn-dashboard-icon');
      break;
    case 326:
      $element['#localized_options']['attributes']['class'] = array('fn-lead-icon');
      break;
    case 397:
      $element['#localized_options']['attributes']['class'] = array('fn-account-icon');
      break;
    case 327:
      $element['#localized_options']['attributes']['class'] = array('fn-order-icon');
      break;
    case 328:
      $element['#localized_options']['attributes']['class'] = array('fn-card-icon');
      break;
    case 398:
      $element['#localized_options']['attributes']['class'] = array('fn-vendor-icon');
      break;
    case 400:
      $element['#localized_options']['attributes']['class'] = array('fn-settings-icon');
      break;
    case 591:
      $element['#localized_options']['attributes']['class'] = array('fn-settings-icon');
      break;
    case 330:
      $element['#localized_options']['attributes']['class'] = array('fn-user-icon');
      break;
    default :
  }

  $output = l($element['#title'], $element['#href'], $element['#localized_options']);
  return '<li' . drupal_attributes($element['#attributes']) . '>' . $output . $sub_menu . "</li>\n";
}

function fernweh_date_combo($variables) {
  return theme('form_element', $variables);
}

function fernweh_fieldset($variables) {
  if (isset($variables['element']['#field_name']) && $variables['element']['#field_name'] == "field_lead_service_flight_attche") {
    return theme('form_element', $variables);
  }
  else {
    $element = $variables ['element'];
    element_set_attributes($element, array('id'));
    _form_set_class($element, array('form-wrapper'));

    $output = '<fieldset' . drupal_attributes($element ['#attributes']) . '>';
    if (!empty($element ['#title'])) {
      // Always wrap fieldset legends in a SPAN for CSS positioning.
      $output .= '<legend><span class="fieldset-legend">' . $element ['#title'] . '</span></legend>';
    }
    $output .= '<div class="fieldset-wrapper">';
    if (!empty($element ['#description'])) {
      $output .= '<div class="fieldset-description">' . $element ['#description'] . '</div>';
    }
    $output .= $element ['#children'];
    if (isset($element ['#value'])) {
      $output .= $element ['#value'];
    }
    $output .= '</div>';
    $output .= "</fieldset>\n";
    return $output;
  }
}

function fernweh_status_messages($variables) {
  $display = $variables['display'];
  $output = '';

  $status_heading = array(
    'status' => t('Status message'),
    'error' => t('Error message'),
    'warning' => t('Warning message'),
  );
  foreach (drupal_get_messages($display) as $type => $messages) {
    $output .= "<div class=\"messages $type\">\n";
    if (!empty($status_heading[$type])) {
      $output .= '<h2 class="element-invisible">' . $status_heading[$type] . "</h2>\n";
    }
    $output .= l(t('Dismiss'), '#', array('attributes' => array('class' => array('message_dismiss_link'))));
    if (count($messages) > 1) {
      $output .= " <ul>\n";
      foreach ($messages as $message) {
        $output .= '  <li>' . $message . "</li>\n";
      }
      $output .= " </ul>\n";
    }
    else {
      $output .= '<span>' . $messages[0] . '</span>';
    }
    $output .= "</div>\n";
  }
  return $output;
}

function fernweh_preprocess_taxonomy_term(&$variables) {
  $variables['view_mode'] = $variables['elements']['#view_mode'];
  $variables['term'] = $variables['elements']['#term'];
  $term = $variables['term'];

  $uri = entity_uri('taxonomy_term', $term);
  $variables['term_url'] = url($uri['path'], $uri['options']);
  $variables['term_name'] = check_plain($term->name);
  $variables['page'] = $variables['view_mode'] == 'full' && taxonomy_term_is_page($term);

  // Flatten the term object's member fields.
  $variables = array_merge((array) $term, $variables);

  // Helpful $content variable for templates.
  $variables['content'] = array();
  foreach (element_children($variables['elements']) as $key) {
    $variables['content'][$key] = $variables['elements'][$key];
  }

  // Overwrite for card detail page
  if ($variables['vid'] == 3) {
    $html = '<div id="account-details-wrapper" class="detail-box-wrapper">';

    $html .= '  <div class="box-heading-left">';
    $html .= '    <h3>Outstanding Balance</h3>';
    $amount = $term->field_card_outstanding_balance[LANGUAGE_NONE][0]['value'];
    if (!is_null($amount) && function_exists('inr_money_format')) {
      $amount = inr_money_format($amount);
    }
    $html .= '    <span>' . $amount . '</span>';
    $html .= '  </div>';

    $html .= '  <div class="box-content-wrapper-rigth">';
    $html .= '    <div class="inner-content-wrapper">';
    $html .= '      <div class="field_wrapper">';
    $html .= '        <div class="field_name">' . t('Card Number') . '</div>';
    $html .= '        <div class="field_value">' . $term->field_card_number[LANGUAGE_NONE][0]['value'] . '</div>';
    $html .= '      </div>';
    $html .= '      <div class="field_wrapper">';
    $html .= '        <div class="field_name">' . t('Bank Name') . '</div>';
    $html .= '        <div class="field_value">' . $term->name . '</div>';
    $html .= '      </div>';
    $html .= '      <div class="field_wrapper">';
    $html .= '        <div class="field_name">' . t('Type') . '</div>';
    $html .= '        <div class="field_value">' . $term->field_card_type[LANGUAGE_NONE][0]['value'] . '</div>';
    $html .= '      </div>';
    $html .= '    </div>';
    $html .= '  </div>';

    $html .= '</div>';
    $variables['content'] = $html;
  }
  // field_attach_preprocess() overwrites the $[field_name] variables with the
  // values of the field in the language that was selected for display, instead
  // of the raw values in $term->[field_name], which contain all values in all
  // languages.
  field_attach_preprocess('taxonomy_term', $term, $variables['content'], $variables);

  // Gather classes, and clean up name so there are no underscores.
  $vocabulary_name_css = str_replace('_', '-', $term->vocabulary_machine_name);
  $variables['classes_array'][] = 'vocabulary-' . $vocabulary_name_css;

  $variables['theme_hook_suggestions'][] = 'taxonomy_term__' . $term->vocabulary_machine_name;
  $variables['theme_hook_suggestions'][] = 'taxonomy_term__' . $term->tid;
}

function fernweh_textarea($variables) {
  $element = $variables ['element'];
  element_set_attributes($element, array('id', 'name', 'cols', 'rows'));
  _form_set_class($element, array('form-textarea'));

  $wrapper_attributes = array(
    'class' => array('form-textarea-wrapper'),
  );
  if ($element['#id'] == "edit-free-text") {
    $wrapper_attributes['style'] = 'margin: 0px;';
  }


  // Add resizable behavior.
  if (!empty($element ['#resizable'])) {
    drupal_add_library('system', 'drupal.textarea');
    $wrapper_attributes ['class'][] = 'resizable';
  }

  $output = '<div' . drupal_attributes($wrapper_attributes) . '>';
  $output .= '<textarea' . drupal_attributes($element ['#attributes']) . '>' . check_plain($element ['#value']) . '</textarea>';
  $output .= '</div>';
  return $output;
}
